/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.model.User;
import com.alibaba.nacos.console.security.nacos.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetails;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.console.utils.PasswordEncoderUtil;
import java.util.Hashtable;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private static final String FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String DEFAULT_PASSWORD = "nacos";
    private static final String LDAP_PREFIX = "LDAP_";
    private static final String DEFAULT_SECURITY_AUTH = "simple";
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private NacosRoleServiceImpl nacosRoleService;
    @Value(value="${nacos.core.auth.ldap.url:ldap://localhost:389}")
    private String ldapUrl;
    @Value(value="${nacos.core.auth.ldap.timeout:3000}")
    private String time;
    @Value(value="${nacos.core.auth.ldap.userdn:cn={0},ou=user,dc=company,dc=com}")
    private String userNamePattern;

    public Authentication authenticate(Authentication authentication) throws org.springframework.security.core.AuthenticationException {
        UserDetails userDetails;
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        if (this.isAdmin(username)) {
            UserDetails userDetails2 = this.userDetailsService.loadUserByUsername(username);
            if (PasswordEncoderUtil.matches(password, userDetails2.getPassword()).booleanValue()) {
                return new UsernamePasswordAuthenticationToken((Object)userDetails2, (Object)password, userDetails2.getAuthorities());
            }
            return null;
        }
        if (!this.ldapLogin(username, password)) {
            return null;
        }
        try {
            userDetails = this.userDetailsService.loadUserByUsername(LDAP_PREFIX + username);
        }
        catch (UsernameNotFoundException exception) {
            String nacosPassword = PasswordEncoderUtil.encode(DEFAULT_PASSWORD);
            this.userDetailsService.createUser(LDAP_PREFIX + username, nacosPassword);
            User user = new User();
            user.setUsername(LDAP_PREFIX + username);
            user.setPassword(nacosPassword);
            userDetails = new NacosUserDetails(user);
        }
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, userDetails.getAuthorities());
    }

    private boolean isAdmin(String username) {
        List<RoleInfo> roleInfos = this.nacosRoleService.getRoles(username);
        if (CollectionUtils.isEmpty(roleInfos)) {
            return false;
        }
        for (RoleInfo roleinfo : roleInfos) {
            if (!"ROLE_ADMIN".equals(roleinfo.getRole())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ldapLogin(String username, String password) throws org.springframework.security.core.AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", FACTORY);
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", DEFAULT_SECURITY_AUTH);
        env.put("java.naming.security.principal", this.userNamePattern.replace("{0}", username));
        env.put("java.naming.security.credentials", password);
        env.put(TIMEOUT, this.time);
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            this.closeContext(ctx);
            return true;
        }
        catch (CommunicationException e) {
            try {
                LOG.error("LDAP Service connect timeout:{}", (Object)e.getMessage());
                throw new RuntimeException("LDAP Service connect timeout");
                catch (AuthenticationException e2) {
                    LOG.error("login error:{}", (Object)e2.getMessage());
                    throw new RuntimeException("login error!");
                }
                catch (Exception e3) {
                    LOG.warn("Exception cause by:{}", (Object)e3.getMessage());
                    boolean bl = false;
                    this.closeContext(ctx);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                this.closeContext(ctx);
                throw throwable;
            }
        }
    }

    public boolean supports(Class<?> aClass) {
        return aClass.equals(UsernamePasswordAuthenticationToken.class);
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception e) {
                LOG.error("Exception closing context", (Throwable)e);
            }
        }
    }
}

