/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.AuthManager;
import com.alibaba.nacos.auth.exception.AccessException;
import com.alibaba.nacos.auth.model.Permission;
import com.alibaba.nacos.auth.model.User;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.console.security.nacos.JwtTokenManager;
import com.alibaba.nacos.console.security.nacos.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.console.security.nacos.users.NacosUser;
import com.alibaba.nacos.core.utils.Loggers;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class NacosAuthManager
implements AuthManager {
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String PARAM_USERNAME = "username";
    private static final String PARAM_PASSWORD = "password";
    @Autowired
    private JwtTokenManager tokenManager;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private NacosRoleServiceImpl roleService;

    public User login(Object request) throws AccessException {
        HttpServletRequest req = (HttpServletRequest)request;
        String token = this.resolveToken(req);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AccessException("user not found!");
        }
        try {
            this.tokenManager.validateToken(token);
        }
        catch (ExpiredJwtException e) {
            throw new AccessException("token expired!");
        }
        catch (Exception e) {
            throw new AccessException("token invalid!");
        }
        Authentication authentication = this.tokenManager.getAuthentication(token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String username = authentication.getName();
        NacosUser user = new NacosUser();
        user.setUserName(username);
        user.setToken(token);
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!roleInfo.getRole().equals("ROLE_ADMIN")) continue;
                user.setGlobalAdmin(true);
                break;
            }
        }
        req.getSession().setAttribute("nacosuser", (Object)user);
        return user;
    }

    public User loginRemote(Object request) throws AccessException {
        Request req = (Request)request;
        String token = this.resolveToken(req);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new AccessException("user not found!");
        }
        try {
            this.tokenManager.validateToken(token);
        }
        catch (ExpiredJwtException e) {
            throw new AccessException("token expired!");
        }
        catch (Exception e) {
            throw new AccessException("token invalid!");
        }
        Authentication authentication = this.tokenManager.getAuthentication(token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String username = authentication.getName();
        NacosUser user = new NacosUser();
        user.setUserName(username);
        user.setToken(token);
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!roleInfo.getRole().equals("ROLE_ADMIN")) continue;
                user.setGlobalAdmin(true);
                break;
            }
        }
        return user;
    }

    public void auth(Permission permission, User user) throws AccessException {
        if (Loggers.AUTH.isDebugEnabled()) {
            Loggers.AUTH.debug("auth permission: {}, user: {}", (Object)permission, (Object)user);
        }
        if (!this.roleService.hasPermission(user.getUserName(), permission)) {
            throw new AccessException("authorization failed!");
        }
    }

    private String resolveToken(HttpServletRequest request) throws AccessException {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith(TOKEN_PREFIX)) {
            return bearerToken.substring(7);
        }
        bearerToken = request.getParameter("accessToken");
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            String userName = request.getParameter(PARAM_USERNAME);
            String password = request.getParameter(PARAM_PASSWORD);
            bearerToken = this.resolveTokenFromUser(userName, password);
        }
        return bearerToken;
    }

    private String resolveToken(Request request) throws AccessException {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith(TOKEN_PREFIX)) {
            return bearerToken.substring(7);
        }
        bearerToken = request.getHeader("accessToken");
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            String userName = request.getHeader(PARAM_USERNAME);
            String password = request.getHeader(PARAM_PASSWORD);
            bearerToken = this.resolveTokenFromUser(userName, password);
        }
        return bearerToken;
    }

    private String resolveTokenFromUser(String userName, String rawPassword) throws AccessException {
        Authentication authenticate;
        try {
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userName, (Object)rawPassword);
            authenticate = this.authenticationManager.authenticate((Authentication)authenticationToken);
        }
        catch (AuthenticationException e) {
            throw new AccessException("unknown user!");
        }
        String finalName = null == authenticate || StringUtils.isBlank((CharSequence)authenticate.getName()) ? userName : authenticate.getName();
        return this.tokenManager.createToken(finalName);
    }
}

