/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.ruleactivator;

import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.ruleactivator.DiskUtils;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleStorage;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;

public class LocalDiskRuleStorage
implements RuleStorage {
    private static final Logger LOGGER = Loggers.CONTROL;
    private String localRruleBaseDir = LocalDiskRuleStorage.defaultBaseDir();

    LocalDiskRuleStorage() {
    }

    private File checkTpsBaseDir() {
        File baseDir = new File(this.localRruleBaseDir, "data" + File.separator + "tps" + File.separator);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        return baseDir;
    }

    public String getLocalRruleBaseDir() {
        return this.localRruleBaseDir;
    }

    public void setLocalRruleBaseDir(String localRruleBaseDir) {
        this.localRruleBaseDir = localRruleBaseDir;
    }

    private static String defaultBaseDir() {
        return LocalDiskRuleStorage.class.getResource("/").getPath();
    }

    private File getConnectionRuleFile() {
        File baseDir = new File(this.localRruleBaseDir, "data" + File.separator + "connection" + File.separator);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        return new File(baseDir, "limitRule");
    }

    @Override
    public String getName() {
        return "localdisk";
    }

    @Override
    public void saveConnectionRule(String ruleContent) throws IOException {
        File pointFile = this.getConnectionRuleFile();
        if (!pointFile.exists()) {
            pointFile.createNewFile();
        }
        DiskUtils.writeFile(pointFile, ruleContent.getBytes("UTF-8"), false);
        LOGGER.info("Save connection rule to local,pointName={}, ruleContent ={} ", (Object)ruleContent);
    }

    @Override
    public String getConnectionRule() {
        File connectionRuleFile = this.getConnectionRuleFile();
        if (!connectionRuleFile.exists()) {
            return null;
        }
        return DiskUtils.readFile(connectionRuleFile);
    }

    @Override
    public void saveTpsRule(String pointName, String ruleContent) throws IOException {
        File file = this.checkTpsBaseDir();
        File tpsFile = new File(file, pointName);
        if (!tpsFile.exists()) {
            tpsFile.createNewFile();
        }
        if (ruleContent == null) {
            DiskUtils.deleteQuietly(tpsFile);
        } else {
            DiskUtils.writeFile(tpsFile, ruleContent.getBytes("UTF-8"), false);
            LOGGER.info("Save tps rule to local,pointName={}, ruleContent ={} ", (Object)pointName, (Object)ruleContent);
        }
    }

    @Override
    public String getTpsRule(String pointName) {
        File file = this.checkTpsBaseDir();
        File tpsFile = new File(file, pointName);
        if (!tpsFile.exists()) {
            return null;
        }
        return DiskUtils.readFile(tpsFile);
    }
}

