/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.api.client.util;

import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.core.AbstractInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.modules.SerializersModule;
import org.jellyfin.sdk.api.client.util.ApiSerializer;
import org.jellyfin.sdk.model.api.SessionMessageType;
import org.jellyfin.sdk.model.socket.IncomingSocketMessage;
import org.jellyfin.sdk.model.socket.OutgoingSocketMessage;
import org.jellyfin.sdk.model.socket.RawIncomingSocketMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0086H\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/jellyfin/sdk/api/client/util/ApiSerializer;", "", "()V", "SOCKET_MESSAGE_DATA", "", "SOCKET_MESSAGE_MESSAGE_ID", "SOCKET_MESSAGE_MESSAGE_TYPE", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "jsonSocketMessage", "decodeResponseBody", "T", "responseBody", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "decodeSocketMessage", "Lorg/jellyfin/sdk/model/socket/IncomingSocketMessage;", "message", "encodeRequestBody", "requestBody", "encodeSocketMessage", "Lorg/jellyfin/sdk/model/socket/OutgoingSocketMessage;", "jellyfin-api"})
public final class ApiSerializer {
    @NotNull
    public static final ApiSerializer INSTANCE = new ApiSerializer();
    @NotNull
    private static final String SOCKET_MESSAGE_DATA = "Data";
    @NotNull
    private static final String SOCKET_MESSAGE_MESSAGE_ID = "MessageId";
    @NotNull
    private static final String SOCKET_MESSAGE_MESSAGE_TYPE = "MessageType";
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    @NotNull
    private static final Json jsonSocketMessage = JsonKt.Json((Json)json, (Function1)jsonSocketMessage.1.INSTANCE);

    private ApiSerializer() {
    }

    @NotNull
    public final Json getJson() {
        return json;
    }

    @Nullable
    public final String encodeRequestBody(@Nullable Object requestBody) {
        if (requestBody == null) {
            return null;
        }
        KSerializer kSerializer = SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(requestBody.getClass()));
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        return json.encodeToString((SerializationStrategy)kSerializer, requestBody);
    }

    public static /* synthetic */ String encodeRequestBody$default(ApiSerializer apiSerializer, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        return apiSerializer.encodeRequestBody(object);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> Object decodeResponseBody(ByteReadChannel responseBody, Continuation<? super T> $completion) {
        Object object;
        boolean $i$f$decodeResponseBody = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Object.class), (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = Unit.INSTANCE;
        } else {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Object.class), (Object)Reflection.getOrCreateKotlinClass(ByteReadChannel.class))) {
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                object = responseBody;
            } else {
                void string$iv;
                void $this$decodeFromString$iv;
                StringFormat stringFormat = (StringFormat)this.getJson();
                InlineMarker.mark((int)0);
                Object object2 = ByteReadChannelKt.readRemaining((ByteReadChannel)responseBody, $completion);
                InlineMarker.mark((int)1);
                String string = AbstractInput.readText$default((AbstractInput)((AbstractInput)object2), (int)0, (int)0, (int)3, null);
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, null);
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                object = $this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, (String)string$iv);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encodeSocketMessage(@NotNull OutgoingSocketMessage message) {
        void value$iv;
        void $this$encodeToString$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        KSerializer kSerializer = SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(message.getClass()));
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        KSerializer serializer = kSerializer;
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)jsonSocketMessage.encodeToJsonElement((SerializationStrategy)serializer, (Object)message));
        String messageType = serializer.getDescriptor().getSerialName();
        StringFormat stringFormat = (StringFormat)jsonSocketMessage;
        boolean $i$f$buildJsonObject22 = false;
        JsonObjectBuilder $this$encodeSocketMessage_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$encodeSocketMessage_u24lambda_u240, (String)SOCKET_MESSAGE_MESSAGE_TYPE, (String)messageType);
        JsonElement data = (JsonElement)jsonObject.get((Object)SOCKET_MESSAGE_DATA);
        if (data != null) {
            $this$encodeSocketMessage_u24lambda_u240.put(SOCKET_MESSAGE_DATA, data);
        } else {
            JsonElementBuildersKt.putJsonObject((JsonObjectBuilder)$this$encodeSocketMessage_u24lambda_u240, (String)SOCKET_MESSAGE_DATA, (Function1)((Function1)new Function1<JsonObjectBuilder, Unit>(jsonObject){
                final /* synthetic */ JsonObject $jsonObject;
                {
                    this.$jsonObject = $jsonObject;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull JsonObjectBuilder $this$putJsonObject) {
                    void $this$filterNotTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$putJsonObject, (String)"$this$putJsonObject");
                    Iterable $this$filterNot$iv = this.$jsonObject.entrySet();
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        Map.Entry entry = (Map.Entry)element$iv$iv;
                        boolean bl = false;
                        String key = (String)entry.getKey();
                        if (Intrinsics.areEqual((Object)key, (Object)"MessageType")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        boolean bl = false;
                        String key = (String)entry.getKey();
                        JsonElement value = (JsonElement)entry.getValue();
                        $this$putJsonObject.put(key, value);
                    }
                }
            }));
        }
        JsonObject $i$f$buildJsonObject22 = builder$iv.build();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv);
    }

    @Nullable
    public final IncomingSocketMessage decodeSocketMessage(@NotNull String message) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StringFormat $this$decodeFromString$iv = (StringFormat)jsonSocketMessage;
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RawIncomingSocketMessage.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        RawIncomingSocketMessage rawMessage = (RawIncomingSocketMessage)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, message);
        if (rawMessage.getType() == SessionMessageType.KEEP_ALIVE) {
            return null;
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$decodeSocketMessage_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$decodeSocketMessage_u24lambda_u242, (String)SOCKET_MESSAGE_MESSAGE_ID, (String)rawMessage.getId().toString());
        JsonElement data = rawMessage.getData();
        if (data instanceof JsonObject) {
            Iterable $this$forEach$iv = ((JsonObject)data).entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                $this$decodeSocketMessage_u24lambda_u242.put(key, value);
            }
        }
        if (data != null) {
            $this$decodeSocketMessage_u24lambda_u242.put(SOCKET_MESSAGE_DATA, data);
        }
        JsonObject modifiedJson = builder$iv.build();
        Object object = jsonSocketMessage.decodeFromJsonElement((DeserializationStrategy)org.jellyfin.sdk.api.sockets.data.SerializersKt.getSerializer(rawMessage.getType()), (JsonElement)modifiedJson);
        return object instanceof IncomingSocketMessage ? (IncomingSocketMessage)object : null;
    }
}

