/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.api.client.util;

import io.ktor.http.CodecsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jellyfin.sdk.api.client.util.AuthorizationHeaderBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jellyfin/sdk/api/client/util/AuthorizationHeaderBuilder;", "", "()V", "AUTHORIZATION_SCHEME", "", "buildHeader", "clientName", "clientVersion", "deviceId", "deviceName", "accessToken", "buildParameter", "key", "value", "encodeParameterValue", "raw", "jellyfin-api"})
public final class AuthorizationHeaderBuilder {
    @NotNull
    public static final AuthorizationHeaderBuilder INSTANCE = new AuthorizationHeaderBuilder();
    @NotNull
    public static final String AUTHORIZATION_SCHEME = "MediaBrowser";

    private AuthorizationHeaderBuilder() {
    }

    @NotNull
    public final String encodeParameterValue(@NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        Regex regex = new Regex("\\n");
        String string = " ";
        return CodecsKt.encodeURLParameter((String)regex.replace(charSequence, string), (boolean)true);
    }

    @NotNull
    public final String buildParameter(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!StringsKt.contains$default((CharSequence)key, (char)'=', (boolean)false, (int)2, null))) {
            boolean $i$a$-require-AuthorizationHeaderBuilder$buildParameter$42 = false;
            String $i$a$-require-AuthorizationHeaderBuilder$buildParameter$42 = "Key " + key + " can not contain the = character in the authorization header";
            throw new IllegalArgumentException($i$a$-require-AuthorizationHeaderBuilder$buildParameter$42.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)key, (char)',', (boolean)false, (int)2, null))) {
            boolean $i$a$-require-AuthorizationHeaderBuilder$buildParameter$52 = false;
            String $i$a$-require-AuthorizationHeaderBuilder$buildParameter$52 = "Key " + key + " can not contain the , character in the authorization header";
            throw new IllegalArgumentException($i$a$-require-AuthorizationHeaderBuilder$buildParameter$52.toString());
        }
        if (!(!StringsKt.startsWith$default((CharSequence)key, (char)'\"', (boolean)false, (int)2, null) && !StringsKt.endsWith$default((CharSequence)key, (char)'\"', (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Key " + key + " can not start or end with the \" character in the authorization header";
            throw new IllegalArgumentException(string.toString());
        }
        return key + "=\"" + this.encodeParameterValue(value) + '\"';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildHeader(@NotNull String clientName, @NotNull String clientVersion, @NotNull String deviceId, @NotNull String deviceName, @Nullable String accessToken) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Pair[] params;
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        Intrinsics.checkNotNullParameter((Object)clientVersion, (String)"clientVersion");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Client", (Object)clientName), TuplesKt.to((Object)"Version", (Object)clientVersion), TuplesKt.to((Object)"DeviceId", (Object)deviceId), TuplesKt.to((Object)"Device", (Object)deviceName), TuplesKt.to((Object)"Token", (Object)accessToken)};
        pairArray = params = pairArray;
        boolean $i$f$filterNot = false;
        void var9_9 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void var15_15 = element$iv$iv = $this$filterNotTo$iv$iv[i];
            boolean bl = false;
            String value = (String)var15_15.component2();
            if (value == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"MediaBrowser ", null, (int)0, null, (Function1)buildHeader.2.INSTANCE, (int)28, null);
    }

    public static /* synthetic */ String buildHeader$default(AuthorizationHeaderBuilder authorizationHeaderBuilder, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        return authorizationHeaderBuilder.buildHeader(string, string2, string3, string4, string5);
    }
}

