/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.api.client.util;

import io.ktor.http.CodecsKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.URLUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jellyfin.sdk.api.client.exception.MissingPathVariableException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJR\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\b2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jellyfin/sdk/api/client/util/UrlBuilder;", "", "()V", "TOKEN_BRACKET_CLOSE", "", "TOKEN_BRACKET_OPEN", "TOKEN_SEPARATOR", "buildPath", "", "template", "parameters", "", "ignorePathParameters", "", "buildUrl", "baseUrl", "pathTemplate", "pathParameters", "queryParameters", "jellyfin-api"})
public final class UrlBuilder {
    @NotNull
    public static final UrlBuilder INSTANCE = new UrlBuilder();
    private static final char TOKEN_SEPARATOR = '/';
    private static final char TOKEN_BRACKET_OPEN = '{';
    private static final char TOKEN_BRACKET_CLOSE = '}';

    private UrlBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildUrl(@NotNull String baseUrl, @NotNull String pathTemplate, @NotNull Map<String, ? extends Object> pathParameters, @NotNull Map<String, ? extends Object> queryParameters, boolean ignorePathParameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Map $this$filterNot$iv;
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)pathTemplate, (String)"pathTemplate");
        Intrinsics.checkNotNullParameter(pathParameters, (String)"pathParameters");
        Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
        URLBuilder $this$buildUrl_u24lambda_u242 = uRLBuilder = URLUtilsKt.URLBuilder((String)baseUrl);
        boolean bl = false;
        URLParserKt.takeFrom((URLBuilder)$this$buildUrl_u24lambda_u242, (String)baseUrl);
        String path = INSTANCE.buildPath(pathTemplate, pathParameters, ignorePathParameters);
        Object object = new char[]{'/'};
        StringBuilder stringBuilder = new StringBuilder().append(StringsKt.trimEnd((String)$this$buildUrl_u24lambda_u242.getEncodedPath(), (char[])object)).append('/');
        object = new char[]{'/'};
        $this$buildUrl_u24lambda_u242.setEncodedPath(stringBuilder.append(StringsKt.trimStart((String)path, (char[])object)).toString());
        object = queryParameters;
        boolean $i$f$filterNot = false;
        void var12_12 = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Object object2 = destination$iv$iv;
            boolean bl3 = false;
            String key = (String)entry.getKey();
            Object rawValue = entry.getValue();
            Collection values = rawValue instanceof Collection ? (Collection)rawValue : (Collection)CollectionsKt.listOfNotNull(rawValue);
            for (Object value : values) {
                $this$buildUrl_u24lambda_u242.getParameters().append(key, String.valueOf(value));
            }
            object2.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return uRLBuilder.buildString();
    }

    public static /* synthetic */ String buildUrl$default(UrlBuilder urlBuilder, String string, String string2, Map map, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "/";
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return urlBuilder.buildUrl(string, string2, map, map2, bl);
    }

    @NotNull
    public final String buildPath(@NotNull String template, @NotNull Map<String, ? extends Object> parameters, boolean ignorePathParameters) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        StringBuilder $this$buildPath_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int lastStart = 0;
        lastStart = -1;
        int lastEnd = -1;
        int n = template.length();
        for (int i = 0; i < n; ++i) {
            String name;
            char c;
            block11: {
                block13: {
                    String content;
                    block12: {
                        c = template.charAt(i);
                        if (c != '/') break block11;
                        if (!(lastStart < 0)) {
                            boolean $i$a$-check-UrlBuilder$buildPath$1$52 = false;
                            StringBuilder stringBuilder2 = new StringBuilder().append("Unclosed path variable ");
                            String string = template.substring(lastStart, i);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            String $i$a$-check-UrlBuilder$buildPath$1$52 = stringBuilder2.append(string).append(" in path ").append(template).toString();
                            throw new IllegalStateException($i$a$-check-UrlBuilder$buildPath$1$52.toString());
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)template.substring(lastEnd + 1, i + 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        if (!Intrinsics.areEqual((Object)content, (Object)"/")) break block12;
                        if (!(((CharSequence)$this$buildPath_u24lambda_u247).length() > 0)) break block13;
                        Character c2 = StringsKt.lastOrNull((CharSequence)$this$buildPath_u24lambda_u247);
                        char $i$a$-check-UrlBuilder$buildPath$1$52 = '/';
                        if (c2 != null && c2.charValue() == $i$a$-check-UrlBuilder$buildPath$1$52) break block13;
                    }
                    $this$buildPath_u24lambda_u247.append(content);
                }
                lastEnd = i;
                continue;
            }
            if (c == '{') {
                if (ignorePathParameters) continue;
                if (!(lastStart < 0)) {
                    boolean $i$a$-check-UrlBuilder$buildPath$1$62 = false;
                    String $i$a$-check-UrlBuilder$buildPath$1$62 = "Nested path variable at " + i + " in path " + template;
                    throw new IllegalStateException($i$a$-check-UrlBuilder$buildPath$1$62.toString());
                }
                String string = template.substring(lastEnd + 1, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$buildPath_u24lambda_u247.append(string);
                lastStart = i + 1;
                continue;
            }
            if (c != '}' || ignorePathParameters) continue;
            if (!(lastStart >= 0)) {
                boolean $i$a$-check-UrlBuilder$buildPath$1$72 = false;
                String $i$a$-check-UrlBuilder$buildPath$1$72 = "End of path variable without start at " + i + " in path " + template;
                throw new IllegalStateException($i$a$-check-UrlBuilder$buildPath$1$72.toString());
            }
            lastEnd = i;
            Intrinsics.checkNotNullExpressionValue((Object)template.substring(lastStart, lastEnd), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (!parameters.containsKey(name)) {
                throw new MissingPathVariableException(name, template, null, 4, null);
            }
            Object value = parameters.get(name);
            if (value != null) {
                $this$buildPath_u24lambda_u247.append(CodecsKt.encodeURLParameter((String)value.toString(), (boolean)true));
            }
            lastStart = -1;
        }
        if (!(lastStart < 0)) {
            boolean bl2 = false;
            StringBuilder stringBuilder3 = new StringBuilder().append("Unclosed path variable ");
            String string = template.substring(lastStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string2 = stringBuilder3.append(string).append(" in path ").append(template).toString();
            throw new IllegalStateException(string2.toString());
        }
        String string = template.substring(lastEnd + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        $this$buildPath_u24lambda_u247.append(string);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    public static /* synthetic */ String buildPath$default(UrlBuilder urlBuilder, String string, Map map, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return urlBuilder.buildPath(string, map, bl);
    }
}

