/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.api.sockets;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jellyfin.sdk.api.client.HttpClientOptions;
import org.jellyfin.sdk.api.sockets.OkHttpWebsocketSession;
import org.jellyfin.sdk.api.sockets.OkHttpWebsocketSessionKt;
import org.jellyfin.sdk.api.sockets.SocketInstanceConnection;
import org.jellyfin.sdk.api.sockets.SocketInstanceState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\u0012\u0018\u0000 %2\u00020\u0001:\u0001%B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010\u001f\u001a\u00020 H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J\u0019\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lorg/jellyfin/sdk/api/sockets/OkHttpWebsocketSession;", "Lorg/jellyfin/sdk/api/sockets/SocketInstanceConnection;", "clientOptions", "Lorg/jellyfin/sdk/api/client/HttpClientOptions;", "incomingMessageChannel", "Lkotlinx/coroutines/channels/Channel;", "", "context", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/jellyfin/sdk/api/client/HttpClientOptions;Lkotlinx/coroutines/channels/Channel;Lkotlin/coroutines/CoroutineContext;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jellyfin/sdk/api/sockets/SocketInstanceState;", "client", "Lokhttp3/OkHttpClient;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "listener", "org/jellyfin/sdk/api/sockets/OkHttpWebsocketSession$listener$1", "Lorg/jellyfin/sdk/api/sockets/OkHttpWebsocketSession$listener$1;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "webSocket", "Lokhttp3/WebSocket;", "connect", "", "url", "authorization", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "message", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "jellyfin-api"})
public final class OkHttpWebsocketSession
implements SocketInstanceConnection {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel<String> incomingMessageChannel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final OkHttpClient client;
    @Nullable
    private WebSocket webSocket;
    @NotNull
    private final MutableStateFlow<SocketInstanceState> _state;
    @NotNull
    private final StateFlow<SocketInstanceState> state;
    @NotNull
    private final listener.1 listener;
    @Deprecated
    @NotNull
    private static final String HEADER_AUTHORIZATION = "Authorization";
    @Deprecated
    private static final int CLOSE_REASON_NORMAL = 1000;

    /*
     * WARNING - void declaration
     */
    public OkHttpWebsocketSession(@NotNull HttpClientOptions clientOptions, @NotNull Channel<String> incomingMessageChannel, @NotNull CoroutineContext context) {
        void $this$client_u24lambda_u240;
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        Intrinsics.checkNotNullParameter(incomingMessageChannel, (String)"incomingMessageChannel");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.incomingMessageChannel = incomingMessageChannel;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)context);
        OkHttpClient.Builder builder2 = builder = new OkHttpClient.Builder();
        OkHttpWebsocketSession okHttpWebsocketSession = this;
        boolean bl = false;
        $this$client_u24lambda_u240.followRedirects(clientOptions.getFollowRedirects());
        $this$client_u24lambda_u240.connectTimeout(clientOptions.getConnectTimeout(), TimeUnit.MILLISECONDS);
        $this$client_u24lambda_u240.readTimeout(clientOptions.getSocketTimeout(), TimeUnit.MILLISECONDS);
        $this$client_u24lambda_u240.writeTimeout(clientOptions.getSocketTimeout(), TimeUnit.MILLISECONDS);
        okHttpWebsocketSession.client = builder.build();
        this._state = StateFlowKt.MutableStateFlow((Object)((Object)SocketInstanceState.DISCONNECTED));
        this.state = FlowKt.asStateFlow(this._state);
        this.listener = new WebSocketListener(this){
            final /* synthetic */ OkHttpWebsocketSession this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                OkHttpWebsocketSessionKt.access$getLogger$p().info((Function0)listener.onOpen.1.INSTANCE);
                OkHttpWebsocketSession.access$get_state$p(this.this$0).setValue((Object)((Object)SocketInstanceState.CONNECTED));
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                OkHttpWebsocketSessionKt.access$getLogger$p().info((Function0)new Function0<Object>(text){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Receiving (raw) message " + this.$text;
                    }
                });
                BuildersKt.launch$default((CoroutineScope)OkHttpWebsocketSession.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, text, null){
                    int label;
                    final /* synthetic */ OkHttpWebsocketSession this$0;
                    final /* synthetic */ String $text;
                    {
                        this.this$0 = $receiver;
                        this.$text = $text;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = OkHttpWebsocketSession.access$getIncomingMessageChannel$p(this.this$0).send((Object)this.$text, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                OkHttpWebsocketSessionKt.access$getLogger$p().warn((Function0)listener.onMessage.3.INSTANCE);
            }

            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                OkHttpWebsocketSessionKt.access$getLogger$p().info((Function0)new Function0<Object>(code, reason){
                    final /* synthetic */ int $code;
                    final /* synthetic */ String $reason;
                    {
                        this.$code = $code;
                        this.$reason = $reason;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "WebSocket is closing, code=" + this.$code + ", reason=" + this.$reason;
                    }
                });
                OkHttpWebsocketSession.access$get_state$p(this.this$0).setValue((Object)((Object)SocketInstanceState.DISCONNECTED));
            }

            public void onClosed(@NotNull WebSocket closedWebSocket, int code, @NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)closedWebSocket, (String)"closedWebSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                OkHttpWebsocketSessionKt.access$getLogger$p().info((Function0)new Function0<Object>(code, reason){
                    final /* synthetic */ int $code;
                    final /* synthetic */ String $reason;
                    {
                        this.$code = $code;
                        this.$reason = $reason;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "WebSocket has closed, code=" + this.$code + ", reason=" + this.$reason;
                    }
                });
                OkHttpWebsocketSession.access$get_state$p(this.this$0).setValue((Object)((Object)SocketInstanceState.DISCONNECTED));
                if (Intrinsics.areEqual((Object)OkHttpWebsocketSession.access$getWebSocket$p(this.this$0), (Object)closedWebSocket)) {
                    OkHttpWebsocketSession.access$setWebSocket$p(this.this$0, null);
                }
            }

            public void onFailure(@NotNull WebSocket failedWebSocket, @NotNull Throwable t, @Nullable Response response) {
                Intrinsics.checkNotNullParameter((Object)failedWebSocket, (String)"failedWebSocket");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                OkHttpWebsocketSessionKt.access$getLogger$p().warn(t, (Function0)listener.onFailure.1.INSTANCE);
                OkHttpWebsocketSession.access$get_state$p(this.this$0).setValue((Object)((Object)SocketInstanceState.ERROR));
                if (Intrinsics.areEqual((Object)OkHttpWebsocketSession.access$getWebSocket$p(this.this$0), (Object)failedWebSocket)) {
                    OkHttpWebsocketSession.access$setWebSocket$p(this.this$0, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public StateFlow<SocketInstanceState> getState() {
        return this.state;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object connect(@NotNull String var1_1, @NotNull String var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof connect.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OkHttpWebsocketSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connect(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.webSocket != null) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = url;
                    $continuation.L$2 = authorization;
                    $continuation.label = 1;
                    v0 = this.disconnect((Continuation<? super Unit>)$continuation);
                    if (v0 == var10_6) {
                        return var10_6;
                    }
                }
                ** GOTO lbl27
            }
            case 1: {
                authorization = (String)$continuation.L$2;
                url = (String)$continuation.L$1;
                this = (OkHttpWebsocketSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                $this$connect_u24lambda_u241 = var5_7 = new Request.Builder();
                $i$a$-apply-OkHttpWebsocketSession$connect$request$1 = false;
                $this$connect_u24lambda_u241.url(url);
                $this$connect_u24lambda_u241.header("Authorization", authorization);
                request = var5_7.build();
                this._state.setValue((Object)SocketInstanceState.CONNECTING);
                this.webSocket = this.client.newWebSocket(request, (WebSocketListener)this.listener);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = FlowKt.first((Flow)((Flow)this.getState()), (Function2)((Function2)new Function2<SocketInstanceState, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SocketInstanceState it = (SocketInstanceState)((Object)this.L$0);
                                return Boxing.boxBoolean((it != SocketInstanceState.CONNECTING ? 1 : 0) != 0);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<SocketInstanceState, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull SocketInstanceState p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl48
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                return Boxing.boxBoolean((boolean)(v1 == SocketInstanceState.CONNECTED));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object send(@NotNull String message, @NotNull Continuation<? super Boolean> $completion) {
        OkHttpWebsocketSessionKt.access$getLogger$p().info((Function0)new Function0<Object>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Sending (raw) message " + this.$message;
            }
        });
        if (this.getState().getValue() != SocketInstanceState.CONNECTED) {
            OkHttpWebsocketSessionKt.access$getLogger$p().warn((Function0)new Function0<Object>(this){
                final /* synthetic */ OkHttpWebsocketSession this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unable to send message: invalid state (state=" + this.this$0.getState().getValue() + ')';
                }
            });
            return Boxing.boxBoolean((boolean)false);
        }
        WebSocket ws = this.webSocket;
        if (ws == null) {
            OkHttpWebsocketSessionKt.access$getLogger$p().warn((Function0)send.4.INSTANCE);
            return Boxing.boxBoolean((boolean)false);
        }
        boolean sent = ws.send(message);
        if (!sent) {
            OkHttpWebsocketSessionKt.access$getLogger$p().warn((Function0)send.5.INSTANCE);
        }
        return Boxing.boxBoolean((boolean)sent);
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        this._state.setValue((Object)SocketInstanceState.DISCONNECTED);
        WebSocket webSocket = this.webSocket;
        if (webSocket != null) {
            Boxing.boxBoolean((boolean)webSocket.close(1000, null));
        }
        this.webSocket = null;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(OkHttpWebsocketSession $this) {
        return $this._state;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(OkHttpWebsocketSession $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Channel access$getIncomingMessageChannel$p(OkHttpWebsocketSession $this) {
        return $this.incomingMessageChannel;
    }

    public static final /* synthetic */ WebSocket access$getWebSocket$p(OkHttpWebsocketSession $this) {
        return $this.webSocket;
    }

    public static final /* synthetic */ void access$setWebSocket$p(OkHttpWebsocketSession $this, WebSocket webSocket) {
        $this.webSocket = webSocket;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jellyfin/sdk/api/sockets/OkHttpWebsocketSession$Companion;", "", "()V", "CLOSE_REASON_NORMAL", "", "HEADER_AUTHORIZATION", "", "jellyfin-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

