/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.model.serializer;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0002j\u0002`\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jellyfin/sdk/model/serializer/DateTimeSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/time/LocalDateTime;", "Lorg/jellyfin/sdk/model/DateTime;", "zoneId", "Ljava/time/ZoneId;", "(Ljava/time/ZoneId;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "jellyfin-model"})
public final class DateTimeSerializer
implements KSerializer<LocalDateTime> {
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    private final SerialDescriptor descriptor;

    public DateTimeSerializer(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"LocalDateTime", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    public /* synthetic */ DateTimeSerializer(ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        this(zoneId);
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public LocalDateTime deserialize(@NotNull Decoder decoder) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        try {
            LocalDateTime localDateTime2 = ZonedDateTime.parse(decoder.decodeString()).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"{\n\t\tZonedDateTime.parse(\u2026g()).toLocalDateTime()\n\t}");
            localDateTime = localDateTime2;
        }
        catch (DateTimeParseException err) {
            LocalDateTime localDateTime3 = LocalDateTime.MIN;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"{\n\t\t// Server will somet\u2026se that\n\t\tDateTime.MIN\n\t}");
            localDateTime = localDateTime3;
        }
        return localDateTime;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.atZone(this.zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.atZone(zoneId).for\u2026ter.ISO_OFFSET_DATE_TIME)");
        encoder.encodeString(string);
    }

    public DateTimeSerializer() {
        this(null, 1, null);
    }
}

