/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.model.serializer;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004*\u00020\u0005\u001a\u0012\u0010\u0006\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004*\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"UUID_REGEX", "Lkotlin/text/Regex;", "toUUID", "Ljava/util/UUID;", "Lorg/jellyfin/sdk/model/UUID;", "", "toUUIDOrNull", "jellyfin-model"})
public final class UUIDSerializerKt {
    @NotNull
    private static final Regex UUID_REGEX = new Regex("^([a-z\\d]{8})([a-z\\d]{4})([a-z\\d]{4})([a-z\\d]{4})([a-z\\d]{12})$");

    @NotNull
    public static final UUID toUUID(@NotNull String $this$toUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$toUUID, (String)"<this>");
        CharSequence charSequence = $this$toUUID;
        Regex regex = UUID_REGEX;
        String string = "$1-$2-$3-$4-$5";
        UUID uUID = UUID.fromString(regex.replace(charSequence, string));
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(replace(UUID_REGEX, \"$1-$2-$3-$4-$5\"))");
        return uUID;
    }

    @Nullable
    public static final UUID toUUIDOrNull(@NotNull String $this$toUUIDOrNull) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)$this$toUUIDOrNull, (String)"<this>");
        try {
            uUID = UUIDSerializerKt.toUUID($this$toUUIDOrNull);
        }
        catch (IllegalArgumentException err) {
            uUID = null;
        }
        return uUID;
    }
}

