/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest;

import com.google.common.io.Resources;
import com.needhamsoftware.unojar.JarClassLoader;
import guru.nidi.graphviz.engine.Format;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.docopt.Docopt;
import org.jesterj.ingest.JavaPlanConfig;
import org.jesterj.ingest.PlanProvider;
import org.jesterj.ingest.forkjoin.JesterJForkJoinThreadFactory;
import org.jesterj.ingest.model.Plan;
import org.jesterj.ingest.persistence.Cassandra;
import org.jesterj.ingest.persistence.JJCassandraDaemon;
import org.jesterj.ingest.utils.JesterJLoader;
import org.jetbrains.annotations.NotNull;

public class Main {
    private static Logger log;
    private static final Object HAPPENS_BEFORE;
    public static String JJ_DIR;
    private static final Thread DUMMY_HOOK;
    private static final Map<String, WeakReference<Plan>> plansByName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object object = HAPPENS_BEFORE;
        synchronized (object) {
            try {
                System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", JesterJForkJoinThreadFactory.class.getName());
                System.setProperty("cassandra.insecure.udf", "true");
                Main.initClassloader();
                Thread contextClassLoaderFix = new Thread(() -> {
                    Object object = HAPPENS_BEFORE;
                    synchronized (object) {
                        try {
                            Map<String, Object> parsedArgs = Main.usage(args);
                            String secret = (String)parsedArgs.get("<secret>");
                            JJCassandraDaemon.defaultPassword(secret);
                            String id = (String)parsedArgs.get("<id>");
                            String ourHome = JJ_DIR + "/" + id;
                            String logDir = Main.setLogDir(ourHome);
                            System.out.println("Logs will be written to: " + logDir);
                            String outfile = (String)parsedArgs.get("-z");
                            String javaConfig = (String)parsedArgs.get("<plan.jar>");
                            boolean runPlan = !Boolean.parseBoolean(String.valueOf(parsedArgs.get("--cassandra-only")));
                            System.out.println("Looking for configuration class in " + javaConfig);
                            if (outfile != null) {
                                Plan p = Main.loadJavaConfig(javaConfig);
                                System.out.println("Generating visualization for " + p.getName() + " into " + outfile);
                                BufferedImage img = p.visualize(Format.PNG).toImage();
                                ImageIO.write((RenderedImage)img, "PNG", new File(outfile));
                                System.exit(0);
                            }
                            Main.startCassandra(parsedArgs);
                            LogManager.getFactory().removeContext(LogManager.getContext((boolean)false));
                            log = LogManager.getLogger(Main.class);
                            Properties sysProps = System.getProperties();
                            for (Object e2 : sysProps.keySet()) {
                                log.trace(e2 + "=" + sysProps.get(e2));
                            }
                            if (runPlan) {
                                if (javaConfig != null) {
                                    Plan p = Main.loadJavaConfig(javaConfig);
                                    log.info("Activating Plan: {}", (Object)p.getName());
                                    p.activate();
                                } else {
                                    System.out.println("Please specify the java config via -Djj.javaConfig=<location of jar file>");
                                    System.exit(11);
                                }
                            }
                            while (true) {
                                try {
                                    while (true) {
                                        List plans = plansByName.entrySet().stream().map(e -> {
                                            Plan plan1 = (Plan)((WeakReference)e.getValue()).get();
                                            return plan1 == null ? ".\n" : "========================\n" + (String)e.getKey() + "\n------------------------\n" + plan1.visualize(Format.DOT) + "\n------------------------\n";
                                        }).collect(Collectors.toList());
                                        for (String plan : plans) {
                                            log.debug(plan);
                                            System.out.println(plan);
                                        }
                                        Thread.sleep(5000L);
                                    }
                                }
                                catch (InterruptedException e2) {
                                    e2.printStackTrace();
                                    Cassandra.stop();
                                    System.exit(0);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                            log.fatal("CRASH and BURNED:", (Throwable)e3);
                        }
                    }
                });
                Field _f_contextClassLoader = Thread.class.getDeclaredField("contextClassLoader");
                _f_contextClassLoader.setAccessible(true);
                _f_contextClassLoader.set(contextClassLoaderFix, ClassLoader.getSystemClassLoader());
                contextClassLoaderFix.setDaemon(false);
                contextClassLoaderFix.start();
            }
            catch (Exception e) {
                System.out.println("CRASH and BURNED before starting main thread:");
                e.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                System.exit(12);
            }
        }
    }

    public static void registerPlan(Plan plan) {
        if (plansByName.containsKey(plan.getName())) {
            throw new IllegalArgumentException("Plan already registered");
        }
        plansByName.put(plan.getName(), new WeakReference<Plan>(plan));
    }

    public static void deregisterPlan(Plan plan) {
        plansByName.remove(plan.getName());
    }

    public static Optional<Plan> locatePlan(String name) {
        WeakReference<Plan> planWeakReference = plansByName.get(name);
        if (planWeakReference == null) {
            return Optional.empty();
        }
        Plan plan = (Plan)planWeakReference.get();
        if (plan == null) {
            return Optional.empty();
        }
        return Optional.of(plan);
    }

    @NotNull
    private static String setLogDir(String logDir) throws IOException {
        File logDirFile;
        String logDirFromProp = System.getProperty("jj.log.dir");
        if (logDirFromProp == null) {
            System.setProperty("jj.log.dir", logDir + "/logs");
        }
        if (!(logDirFile = new File(logDirFromProp = System.getProperty("jj.log.dir"))).mkdirs() && !logDirFile.canWrite()) {
            System.out.println("Cannot write to " + logDirFromProp + " \nPlease fix the filesystem permissions or provide a writable location with -Djj.log.dir property on the command line.");
            System.exit(99);
        }
        String logConfig = logDirFromProp + "/log4j2.xml";
        System.setProperty("log4j.configurationFile", logConfig);
        File configFile = new File(logConfig);
        if (!configFile.exists()) {
            try (InputStream log4jXml = Main.class.getResourceAsStream("/log4j2.xml");){
                Files.copy(Objects.requireNonNull(log4jXml), configFile.toPath(), new CopyOption[0]);
            }
        }
        return logDirFromProp;
    }

    private static void startCassandra(Map<String, Object> parsedArgs) {
        String cassandraHome = (String)parsedArgs.get("--cassandra-home");
        File cassandraDir = null;
        if (cassandraHome != null && !(cassandraDir = new File(cassandraHome = cassandraHome.replaceFirst("^~", System.getProperty("user.home")))).isDirectory()) {
            System.err.println("\nERROR: --cassandra-home must specify a directory\n");
            System.exit(13);
        }
        String id = (String)parsedArgs.get("<id>");
        if (cassandraDir == null) {
            cassandraDir = new File(JJ_DIR + "/" + id + "/cassandra");
        }
        Cassandra.start(cassandraDir);
    }

    private static Plan loadJavaConfig(String javaConfig) throws InstantiationException, IllegalAccessException {
        Plan plan;
        block26: {
            URLClassLoader loader;
            URL planConfigJarURL;
            File file = new File(javaConfig);
            if (!file.exists()) {
                System.err.println("File not found:" + file);
                System.exit(14);
            }
            boolean isUnoJar = false;
            try {
                Attributes attrs;
                try (JarFile test = new JarFile(file);){
                    attrs = test.getManifest().getMainAttributes();
                }
                String attr = attrs.getValue("Archive-Type");
                isUnoJar = attr != null && attr.trim().equalsIgnoreCase("uno-jar");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(15);
            }
            boolean finalIsUnoJar = isUnoJar;
            if (log != null) {
                log.info("Loading from {} which is a {} file", new Supplier[]{() -> file, () -> finalIsUnoJar ? "Uno-Jar" : "Standard Jar"});
            } else {
                System.out.println("Loading from " + file + " which is a " + (finalIsUnoJar ? "Uno-Jar" : "Standard Jar") + " file");
            }
            File jarfile = new File(javaConfig);
            try {
                planConfigJarURL = jarfile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            JesterJLoader jesterJLoader = (JesterJLoader)ClassLoader.getSystemClassLoader();
            if (isUnoJar) {
                JarClassLoader jarClassLoader = new JarClassLoader((ClassLoader)jesterJLoader, planConfigJarURL.toString());
                jarClassLoader.load(null);
                loader = jarClassLoader;
            } else {
                loader = new URLClassLoader(new URL[]{planConfigJarURL}, (ClassLoader)jesterJLoader);
            }
            jesterJLoader.addExtLoader(loader);
            ScanResult scanResult = new ClassGraph().overrideClassLoaders(new ClassLoader[]{loader}).ignoreParentClassLoaders().enableClassInfo().enableAnnotationInfo().scan();
            try {
                String routeAnnotation = JavaPlanConfig.class.getName();
                ClassInfoList classesWithAnnotation = scanResult.getClassesWithAnnotation(routeAnnotation);
                List planProducers = classesWithAnnotation.stream().map(ClassInfo::getName).collect(Collectors.toList());
                if (log != null) {
                    log.info("Found the following @JavaPlanConfig classes (first in list will be used):{}", planProducers);
                } else {
                    System.out.println("Found the following @JavaPlanConfig classes (first in list will be used):" + planProducers);
                }
                if (classesWithAnnotation.size() == 0) {
                    System.err.println("No Plan Found!");
                    System.exit(16);
                }
                Class<?> config = jesterJLoader.loadClass((String)planProducers.get(0));
                PlanProvider provider = (PlanProvider)config.newInstance();
                plan = provider.getPlan();
                if (scanResult == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (scanResult != null) {
                        try {
                            scanResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Found a plan class but could not load Plan's class file!");
                    System.exit(17);
                    throw new RuntimeException();
                }
            }
            scanResult.close();
        }
        return plan;
    }

    private static void initClassloader() throws NoSuchFieldException, IllegalAccessException {
        ClassLoader unoJarClassLoader = Main.class.getClassLoader();
        String name = unoJarClassLoader.getClass().getName();
        if ("com.needhamsoftware.unojar.JarClassLoader".equals(name)) {
            Field scl = ClassLoader.class.getDeclaredField("scl");
            scl.setAccessible(true);
            scl.set(null, new JesterJLoader(new URL[0], unoJarClassLoader));
        }
    }

    private static Map<String, Object> usage(String[] args) throws IOException {
        URL usage = Resources.getResource((String)"usage.docopts.txt");
        String usageStr = Resources.toString((URL)usage, (Charset)StandardCharsets.UTF_8);
        Map result = new Docopt(usageStr).parse(args);
        System.out.println("\nReceived arguments:");
        for (String s : result.keySet()) {
            System.out.printf("   %s:%s\n", s, result.get(s));
        }
        if (((Boolean)result.get("--help")).booleanValue()) {
            System.out.println(usageStr);
            System.exit(18);
        }
        return result;
    }

    public static synchronized boolean isNotShuttingDown() {
        try {
            Runtime.getRuntime().addShutdownHook(DUMMY_HOOK);
            Runtime.getRuntime().removeShutdownHook(DUMMY_HOOK);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    static {
        HAPPENS_BEFORE = new Object();
        DUMMY_HOOK = new Thread();
        plansByName = new ConcurrentHashMap<String, WeakReference<Plan>>();
        String userDir = System.getProperty("user.home");
        File jjDir = new File(userDir + "/.jj");
        if (!jjDir.exists() && !jjDir.mkdir()) {
            throw new RuntimeException("could not create " + jjDir);
        }
        try {
            JJ_DIR = jjDir.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(10);
        }
    }
}

