/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.logging;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.jesterj.ingest.persistence.Cassandra;
import org.jesterj.ingest.persistence.CassandraSupport;

public class CassandraLog4JManager
extends AbstractManager {
    public static final String CREATE_LOG_KEYSPACE = "CREATE KEYSPACE IF NOT EXISTS jj_logging WITH REPLICATION = { 'class' : 'SimpleStrategy', 'replication_factor' : 1 };";
    public static final String CREATE_LOG_TABLE = "CREATE TABLE IF NOT EXISTS jj_logging.regular(id uuid PRIMARY KEY, logger text, tstamp timestamp, level text, thread text, message text);";
    private final Future<Object> cassandraReady;
    final Executor executor = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    protected CassandraLog4JManager(String name) {
        super(LoggerContext.getContext(), name);
        System.out.println(">>>> Creating CassandraLog4JManager");
        CassandraSupport cassandra = new CassandraSupport();
        SchemaChecker makeTables = new SchemaChecker(cassandra);
        this.cassandraReady = cassandra.whenBooted(makeTables);
    }

    void ensureBasicSchema(CqlSession session) {
        session.setSchemaMetadataEnabled(Boolean.valueOf(false));
        session.execute(CREATE_LOG_KEYSPACE);
        session.execute(CREATE_LOG_TABLE);
        session.checkSchemaAgreement();
        session.setSchemaMetadataEnabled(Boolean.valueOf(true));
    }

    public boolean isReady() {
        return this.cassandraReady.isDone();
    }

    private class SchemaChecker
    implements Callable<Object> {
        private final CassandraSupport cassandra;

        public SchemaChecker(CassandraSupport cassandra) {
            this.cassandra = cassandra;
        }

        @Override
        public Object call() throws Exception {
            System.out.println("Table and key space creation thread started");
            boolean tryAgain = true;
            int tryCount = 0;
            while (tryAgain) {
                try {
                    CqlSession session = this.getCassandra().getSession();
                    CassandraLog4JManager.this.ensureBasicSchema(session);
                    tryAgain = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                    if (++tryCount <= 10) continue;
                    this.die(e);
                    tryAgain = false;
                }
            }
            return null;
        }

        void die(Exception e) {
            CassandraLog4JManager.this.executor.execute(() -> {
                try {
                    LogManager.getRootLogger().error("!!!!\n!!!!\nShutting down in 5 seconds due to persistence failure: " + e.getMessage() + "\n!!!!\n!!!!");
                    Cassandra.stop();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                System.exit(30);
            });
        }

        CassandraSupport getCassandra() {
            return this.cassandra;
        }
    }
}

