/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.logging;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.tika.utils.StringUtils;
import org.jesterj.ingest.Main;
import org.jesterj.ingest.logging.CassandraLog4JManager;
import org.jesterj.ingest.logging.CassandraLog4JManagerFactory;
import org.jesterj.ingest.logging.Markers;
import org.jesterj.ingest.model.Plan;
import org.jesterj.ingest.model.Scanner;
import org.jesterj.ingest.persistence.Cassandra;
import org.jesterj.ingest.persistence.CassandraSupport;
import org.jesterj.ingest.processors.DocumentLoggingContext;

@Plugin(name="JesterJAppender", category="Core", elementType="appender")
public class JesterJAppender
extends AbstractAppender {
    public static final int FTI_TTL = 7776000;
    public static final List<DocumentLoggingContext.ContextNames> PER_EVENT_CONTEXT = List.of(DocumentLoggingContext.ContextNames.JJ_SCANNER_NAME, DocumentLoggingContext.ContextNames.JJ_OUTPUT_STEP_CHANGES, DocumentLoggingContext.ContextNames.JJ_STATUS_CHANGES);
    private static final String INSERT_REG = "INSERT INTO jj_logging.regular (id, logger, tstamp, level, thread, message) VALUES(?,?,?,?,?,?)";
    private static final String INSERT_FTI = "INSERT INTO %s.jj_output_step_status (docid, docHash, parentId, origParentId, outputStepName, status, message, antiCollision, created, createdNanos) VALUES(?,?,?,?,?,?,?,?,?,?) USING TTL ?";
    public static final String REG_INSERT_U = "REG_INSERT_U";
    public static final String FTI_INSERT_U = "FTI_INSERT_U";
    private static final CassandraSupport cassandra = new CassandraSupport();
    public static final String DELIM = "#,#";
    public static final Pattern MESSAGE_DELIMITER = Pattern.compile("#,#");
    private static CassandraLog4JManager manager;
    private static final Queue<LogEvent> startupQueue;

    protected JesterJAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, null);
    }

    protected JesterJAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, null, ignoreExceptions);
    }

    public JesterJAppender(String name, Layout<? extends Serializable> layout, Filter filter, CassandraLog4JManager manager, boolean ignoreExceptions) {
        super(name, filter, null, ignoreExceptions);
        JesterJAppender.manager = manager;
    }

    @PluginFactory
    public static JesterJAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for JesterJAppender");
            return null;
        }
        manager = JesterJAppender.createManager();
        if (manager == null) {
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        cassandra.addStatement(REG_INSERT_U, INSERT_REG);
        return new JesterJAppender(name, (Layout<? extends Serializable>)layout, filter, manager, ignoreExceptions);
    }

    private static CassandraLog4JManager createManager() {
        return new CassandraLog4JManagerFactory().createManager("jjCassandraManager", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        if (!manager.isReady()) {
            startupQueue.add(event);
        } else {
            if (!startupQueue.isEmpty()) {
                Queue<LogEvent> queue = startupQueue;
                synchronized (queue) {
                    if (startupQueue.peek() != null) {
                        for (LogEvent logEvent : startupQueue) {
                            System.out.println("Logging event removed from startup queue");
                            this.writeEvent(logEvent);
                        }
                        startupQueue.clear();
                    }
                }
            }
            this.writeEvent(event);
        }
    }

    private void writeEvent(LogEvent e) {
        Marker m = e.getMarker();
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,'Z'").format(e.getTimeMillis());
        String logger = String.valueOf(e.getLoggerName());
        Instant timeStamp = Instant.ofEpochMilli(e.getTimeMillis());
        String level = String.valueOf(e.getLevel());
        String thread = String.valueOf(Thread.currentThread().getName());
        String message = String.valueOf(e.getMessage().getFormattedMessage());
        if (m == null || m.isInstanceOf(Markers.LOG_MARKER)) {
            int i;
            CqlSession s = cassandra.getSession();
            PreparedStatement pq = cassandra.getPreparedQuery(REG_INSERT_U);
            System.setProperty("java.util.secureRandomSeed", "true");
            ThreadLocalRandom current = ThreadLocalRandom.current();
            byte[] rand = new byte[16];
            current.nextBytes(rand);
            rand[6] = (byte)(rand[6] & 0xF);
            rand[6] = (byte)(rand[6] | 0x40);
            rand[8] = (byte)(rand[8] & 0x3F);
            rand[8] = (byte)(rand[8] | 0x80);
            long mostSignificantBits = 0L;
            long leastSignificantBits = 0L;
            for (i = 0; i < 8; ++i) {
                mostSignificantBits = mostSignificantBits << 8 | (long)(rand[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                leastSignificantBits = leastSignificantBits << 8 | (long)(rand[i] & 0xFF);
            }
            UUID id = new UUID(mostSignificantBits, leastSignificantBits);
            s.execute((Statement)pq.bind(new Object[]{id, logger, timeStamp, level, thread, message}));
            return;
        }
        if (m.isInstanceOf(Markers.FTI_MARKER)) {
            CqlSession s = cassandra.getSession();
            Map contextData = e.getContextData().toMap();
            String outputStepNames = (String)contextData.get(String.valueOf((Object)DocumentLoggingContext.ContextNames.JJ_OUTPUT_STEP_CHANGES));
            String[] changedSteps = outputStepNames.split(",");
            String statuses = (String)contextData.get(String.valueOf((Object)DocumentLoggingContext.ContextNames.JJ_STATUS_CHANGES));
            String[] changedStatuses = statuses.split(",");
            String messages = e.getMessage().getFormattedMessage();
            String[] changeMessages = MESSAGE_DELIMITER.split(messages);
            String planName = (String)contextData.get("JJ_PLAN_NAME");
            String scannerName = (String)contextData.get(String.valueOf((Object)DocumentLoggingContext.ContextNames.JJ_SCANNER_NAME));
            int numberOfChanges = changedSteps.length;
            if (changedStatuses.length != numberOfChanges || changeMessages.length != numberOfChanges) {
                throw new IllegalStateException("Cannot process document status update when the number of statuses, changes, messages and arg lists does ot match. This is always a bug in JesterJ");
            }
            if (Arrays.stream(changedSteps).anyMatch(StringUtils::isBlank)) {
                throw new IllegalStateException("Blank Step name detected! Info --> \n\toutputStepNames:" + outputStepNames + "\n\tstatuses:" + statuses + "\n\tmessages:" + messages + "\n\tplanName:" + planName);
            }
            if (planName == null) {
                throw new IllegalStateException("Null Plan name name detected! Info --> \n\toutputStepNames:" + outputStepNames + "\n\tstatuses:" + statuses + "\n\tmessages:" + messages + "\n\tplanName:" + planName);
            }
            for (int i = 0; i < changedSteps.length; ++i) {
                DocumentLoggingContext.ContextNames[] names;
                String changedStep = changedSteps[i];
                Plan plan = Main.locatePlan(planName).orElseThrow();
                Scanner step = (Scanner)plan.findStep(scannerName);
                String keySpace = step.keySpace(changedStep);
                String sq = String.format(INSERT_FTI, keySpace);
                PreparedStatement update = cassandra.getPreparedQuery("FTI_INSERT_U_" + keySpace, sq);
                ArrayList<Object> params = new ArrayList<Object>(16);
                for (DocumentLoggingContext.ContextNames name : names = DocumentLoggingContext.ContextNames.values()) {
                    if (PER_EVENT_CONTEXT.contains((Object)name)) continue;
                    params.add(contextData.get(String.valueOf((Object)name)));
                }
                params.add(changedStep);
                params.add(changedStatuses[i]);
                params.add(changeMessages[i]);
                params.add(CassandraSupport.antiCollision.get().nextInt());
                params.add(Instant.now());
                params.add((int)(System.nanoTime() % 1000000L));
                params.add(7776000);
                try {
                    s.execute((Statement)update.bind(params.toArray()));
                    continue;
                }
                catch (NoNodeAvailableException ex) {
                    if (Cassandra.isStopping()) continue;
                    throw ex;
                }
            }
        }
    }

    static {
        startupQueue = new ConcurrentLinkedQueue<LogEvent>();
    }
}

