/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model;

import java.io.Serializable;
import java.util.Arrays;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.model.Step;

public class DocDestinationStatus
implements Serializable {
    private final Status status;
    private final String message;
    private final String outputDestination;
    Serializable[] messageArgs;

    public DocDestinationStatus(Status status, String outputDestination, String message, Serializable ... messageArgs) {
        if (messageArgs != null) {
            for (Serializable messageArg : messageArgs) {
                if (messageArg == null) continue;
                if (Step.class.isAssignableFrom(messageArg.getClass())) {
                    throw new RuntimeException("Never add a step object to the destination status message, use the step name instead");
                }
                if (!Document.class.isAssignableFrom(messageArg.getClass())) continue;
                throw new RuntimeException("Never add a Document object to the destination status message, use the document id or other string representation. Note that very long strings (like DocumentImpl.toString() will take up a LOT of space in our internal Cassandra persistence and may impact performance");
            }
        }
        this.status = status;
        this.message = message;
        this.outputDestination = outputDestination;
        this.messageArgs = messageArgs;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getOutputDestination() {
        return this.outputDestination;
    }

    public String toString() {
        return "DocDestinationStatus{status=" + this.status + ", message='" + this.message + "', outputStep='" + this.outputDestination + "', messageArgs=" + Arrays.toString(this.messageArgs) + "}";
    }

    public Object[] getMessageParams() {
        return this.messageArgs;
    }
}

