/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.model.Step;

public class DocStatusChange
implements Serializable {
    private final Status status;
    private final String message;
    private final Collection<String> specificDestinations;
    Serializable[] messageArgs;

    public DocStatusChange(Status status, String message, Serializable ... messageArgs) {
        this(status, message, (Collection<String>)null, messageArgs);
    }

    public DocStatusChange(Status status, String message, Collection<String> specificDestinations, Serializable ... messageArgs) {
        this.specificDestinations = specificDestinations;
        if (messageArgs != null) {
            for (Serializable messageArg : messageArgs) {
                if (messageArg == null) continue;
                if (Step.class.isAssignableFrom(messageArg.getClass())) {
                    throw new RuntimeException("Never add a step object to the destination status message, use the step name instead");
                }
                if (!Document.class.isAssignableFrom(messageArg.getClass())) continue;
                throw new RuntimeException("Never add a Document object to the destination status message, use the document id or other string representation. Note that very long strings (like DocumentImpl.toString() will take up a LOT of space in our internal Cassandra persistence and may impact performance");
            }
        }
        this.status = status;
        this.message = message;
        this.messageArgs = messageArgs;
    }

    public String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "DocStatusChange{status=" + this.status + ", message='" + this.message + "', specificSteps=" + this.specificDestinations + ", messageArgs=" + Arrays.toString(this.messageArgs) + "}";
    }

    public Object[] getMessageParams() {
        return this.messageArgs;
    }

    public Collection<String> getSpecificDestinations() {
        return this.specificDestinations;
    }
}

