/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.utils.Cloner;

public class NextSteps {
    public static final Cloner<Document> CLONER = new Cloner();
    Map<Step, StepStatusHolder> steps = new HashMap<Step, StepStatusHolder>();

    public NextSteps(Document doc, Step ... next) {
        Objects.requireNonNull(doc);
        Objects.requireNonNull(next);
        if (next.length == 0) {
            throw new RuntimeException("Router selected no next steps. This is a bug in the router implementation or a misconfigured router");
        }
        if (next.length == 1) {
            this.steps.put(next[0], new StepStatusHolder(StepStatus.TRY, doc));
            return;
        }
        for (Step step : next) {
            try {
                Document tmp = CLONER.cloneObj(doc);
                tmp.removeAllOtherDestinationsQuietly(step.getOutputDestinationNames());
                if (tmp.getIncompleteOutputDestinations().length <= 0) continue;
                this.steps.put(step, new StepStatusHolder(StepStatus.TRY, tmp));
            }
            catch (IOException | ClassNotFoundException e) {
                StepStatusHolder stepStatusHolder = new StepStatusHolder(StepStatus.FAIL, null);
                stepStatusHolder.setException(e);
                this.steps.put(step, stepStatusHolder);
            }
        }
    }

    public void update(Step step, StepStatus stepStatus) {
        this.steps.get(step).setStatus(stepStatus);
    }

    public int size() {
        return this.steps.size();
    }

    public List<Step> list() {
        return new ArrayList<Step>(this.steps.keySet());
    }

    public List<Map.Entry<Step, StepStatusHolder>> remaining() {
        return this.steps.entrySet().stream().filter(e -> ((StepStatusHolder)e.getValue()).getStatus().ordinal() < StepStatus.SENT.ordinal()).collect(Collectors.toList());
    }

    public String toString() {
        return "NextSteps{steps=" + this.steps + "}";
    }

    public static class StepStatusHolder {
        private StepStatus status;
        private final Document doc;
        private Exception exception;

        StepStatusHolder(StepStatus status, Document doc) {
            this.status = status;
            this.doc = doc;
        }

        public Document getDoc() {
            return this.doc;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setStatus(StepStatus status) {
            this.status = status;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public StepStatus getStatus() {
            return this.status;
        }
    }

    public static enum StepStatus {
        TRY,
        RETRY,
        SENT,
        FAIL;

    }
}

