/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import org.jesterj.ingest.model.Active;
import org.jesterj.ingest.model.Configurable;
import org.jesterj.ingest.model.DeferredBuilding;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.NextSteps;
import org.jesterj.ingest.model.Plan;
import org.jesterj.ingest.model.Router;
import org.jesterj.ingest.model.impl.StepImpl;

public interface Step
extends Active,
BlockingQueue<Document>,
Runnable,
DeferredBuilding,
Configurable {
    public static final String JJ_PLAN_VERSION = "JJ_PLAN_VERSION";
    public static final String JJ_PLAN_NAME = "JJ_PLAN_NAME";

    public int getBatchSize();

    public NextSteps getNextSteps(Document var1);

    public Plan getPlan();

    public void sendToNext(Document var1);

    public Set<String> getOutputDestinationNames();

    public Set<Step> getDownstreamOutputSteps();

    public boolean isOutputStep();

    public LinkedHashMap<String, Step> getNextSteps();

    public LinkedHashMap<String, Step> getEligibleNextSteps(Document var1);

    public boolean isActivePriorSteps();

    public List<Step> getPriorSteps();

    public void addPredecessor(StepImpl var1);

    public Router getRouter();

    default public boolean isOutputDestinationThisStep(String destinationPath) {
        String name = this.getName();
        Pattern patternForStep = StepImpl.getPatternForStep(name);
        return patternForStep.matcher(destinationPath).matches();
    }
}

