/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.jesterj.ingest.Main;
import org.jesterj.ingest.logging.Markers;
import org.jesterj.ingest.model.DocDestinationStatus;
import org.jesterj.ingest.model.DocStatusChange;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.Plan;
import org.jesterj.ingest.model.Router;
import org.jesterj.ingest.model.Scanner;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.model.StatusReporter;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.processors.DocumentLoggingContext;
import org.jesterj.ingest.utils.Cloner;

public class DocumentImpl
implements Document {
    public static final String CHILD_SEP = "\u21db";
    public static final Pattern DEFAULT_TO_STRING = Pattern.compile("([A-Za-z_.0-9]+=\\[[^=]*[0-9_a-z.]+\\.[0-9_A-Za-z.]+@[0-9A-F]+)]}?,");
    private final String idField;
    private static final Logger log = LogManager.getLogger();
    private final ListMultimap<String, String> delegate = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private byte[] rawData;
    private final Document.Operation operation;
    private final String sourceScannerName;
    private final String parentId;
    private final String originalParentId;
    private String docHash;
    private boolean forceReprocess;
    private DocStatusChange statusChange;
    private final Map<String, DocDestinationStatus> incompleteOutputDestinations = new ConcurrentHashMap<String, DocDestinationStatus>();
    private final String origination;
    private transient StatusReporter statusReporter;
    private transient boolean newDocAllowedToSetProcessingStatus = true;

    public DocumentImpl(byte[] rawData, String id, Plan plan, Document.Operation operation, Scanner source, String origination) {
        this(rawData, id, plan.getDocIdField(), operation, source.getName(), null, id, origination);
    }

    DocumentImpl(byte[] rawData, String id, String idField, Document.Operation operation, String source, String parentId, String originalParentId, String origination) {
        this.rawData = rawData;
        this.operation = operation;
        this.sourceScannerName = source;
        this.idField = idField;
        this.parentId = parentId;
        this.originalParentId = originalParentId;
        this.delegate.put((Object)idField, (Object)id);
        if (this.rawData != null) {
            this.delegate.put((Object)"doc_raw_size", (Object)String.valueOf(this.rawData.length));
        }
        this.origination = origination;
    }

    public DocumentImpl(byte[] rawData, String id, Document.Operation oper, DocumentImpl parent) {
        this.rawData = rawData;
        if (this.rawData != null) {
            this.delegate.put((Object)"doc_raw_size", (Object)String.valueOf(this.rawData.length));
        }
        this.operation = oper;
        this.idField = parent.idField;
        this.delegate.put((Object)this.idField, (Object)id);
        this.sourceScannerName = parent.sourceScannerName;
        this.parentId = parent.getId();
        this.originalParentId = parent.originalParentId;
        this.origination = parent.origination;
        Cloner<DocDestinationStatus> cloner = new Cloner<DocDestinationStatus>();
        for (Map.Entry<String, DocDestinationStatus> step : parent.incompleteOutputDestinations.entrySet()) {
            try {
                this.incompleteOutputDestinations.put(step.getKey(), cloner.cloneObj(step.getValue()));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Document makeChild(byte[] rawData, Document.Operation operation, int childId) {
        return new DocumentImpl(rawData, this.getId() + CHILD_SEP + childId, operation, this);
    }

    @Override
    public boolean putAll(@Nullable String key, Iterable<? extends String> values) {
        return this.delegate.putAll((Object)key, values);
    }

    @Override
    public boolean put(@Nonnull String key, @Nonnull String value) {
        if (this.getIdField().equals(key)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            List<String> prev = this.replaceValues(this.idField, values);
            return prev == null || prev.size() != 1 || !prev.get(0).equals(value);
        }
        return this.delegate.put((Object)key, (Object)value);
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return this.delegate.containsEntry(key, value);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Collection<Map.Entry<String, String>> entries() {
        return this.delegate.entries();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Map<String, Collection<String>> asMap() {
        return this.delegate.asMap();
    }

    @Override
    public List<String> replaceValues(@Nullable String key, Iterable<? extends String> values) {
        return this.delegate.replaceValues((Object)key, values);
    }

    @Override
    public Collection<String> values() {
        return this.delegate.values();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public List<String> get(@Nullable String key) {
        return this.delegate.get((Object)key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<String> removeAll(@Nullable Object key) {
        return this.delegate.removeAll(key);
    }

    @Override
    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    @Override
    public Status getStatus(String outputDestination) {
        Collection<String> specificSteps;
        if (this.statusChange != null && (specificSteps = this.statusChange.getSpecificDestinations()) != null && specificSteps.contains(outputDestination)) {
            return this.statusChange.getStatus();
        }
        DocDestinationStatus result = this.incompleteOutputDestinations.get(outputDestination);
        return result == null ? null : result.getStatus();
    }

    @Override
    public String getStatusMessage(String outputDestination) {
        if (this.statusChange != null && this.statusChange.getSpecificDestinations().contains(outputDestination)) {
            return this.statusChange.getMessage();
        }
        return this.incompleteOutputDestinations.get(outputDestination).getMessage();
    }

    public void setStatusForDestinations(Status status, Collection<String> destinations, String statusMessage, Serializable ... messageArgs) {
        if (!destinations.stream().allMatch(this.incompleteOutputDestinations::containsKey)) {
            throw new UnsupportedOperationException("Do not add new downstream steps via setStatus. Tried to add:" + destinations + " existing:" + this.incompleteOutputDestinations);
        }
        ArrayList<Serializable[]> argTmp = new ArrayList<Serializable[]>();
        for (String ignored : destinations) {
            argTmp.add(messageArgs);
        }
        messageArgs = argTmp.stream().flatMap(Arrays::stream).collect(Collectors.toList()).toArray(new Serializable[0]);
        this.statusChange = new DocStatusChange(status, statusMessage, destinations, messageArgs);
    }

    @Override
    public ListMultimap<String, String> getDelegate() {
        return this.delegate;
    }

    @Override
    public String getId() {
        return this.get(this.getIdField()).get(0);
    }

    @Override
    public String getHash() {
        if (this.docHash != null) {
            return this.docHash;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.getHashAlg());
            String delegateString = this.getDelegateString();
            Matcher m = DEFAULT_TO_STRING.matcher(delegateString);
            if (m.matches()) {
                log.warn("Detected possible default Object.toString() when calculating hash code for {}! If allowed, this will lead to non-reproducable hash codes due to the inclusion of java memory addresses that are non-deterministic. The normal fix is to implement toString() for the object, orserialize the object in a deterministic fashion before adding it to the document when scanning.Offending match={}", (Object)this.getId(), (Object)m.group(1));
            }
            md.update(delegateString.getBytes(StandardCharsets.UTF_8));
            if (this.getRawData() != null) {
                md.update(this.getRawData());
            }
            this.docHash = new String(Hex.encodeHex((byte[])md.digest(), (boolean)false));
            return this.docHash;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    String getDelegateString() {
        return this.delegate.toString();
    }

    @Override
    public String getIdField() {
        return this.idField;
    }

    @Override
    public Document.Operation getOperation() {
        return this.operation;
    }

    @Override
    public String getSourceScannerName() {
        return this.sourceScannerName;
    }

    @Override
    public String getFirstValue(String fieldName) {
        List<String> values = this.get(fieldName);
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getOrignalParentId() {
        return this.originalParentId;
    }

    public String toString() {
        return "DocumentImpl{id=" + this.getId() + ", delegate=" + this.delegate + ", status=" + this.incompleteOutputDestinations + ", statusChanges=" + this.statusChange + ", operation=" + this.operation + ", sourceScannerName='" + this.sourceScannerName + "', idField='" + this.idField + "', origin=" + this.origination + "}";
    }

    @Override
    public boolean isStatusChanged() {
        return this.statusChange != null;
    }

    @Override
    public void reportDocStatus() {
        this.statusReporter.reportStatus(this);
    }

    void stepStarted(Step step) {
        this.statusReporter = new StatusReporterImpl(step);
    }

    public void initDestinations(Set<String> outputDestinationNames, String scannerName) {
        for (String downStream : outputDestinationNames) {
            this.incompleteOutputDestinations.put(downStream, new DocDestinationStatus(Status.PROCESSING, downStream, "ignore", new Serializable[0]));
        }
        this.statusChange = new DocStatusChange(Status.PROCESSING, "New content found by {}.", new Serializable[]{scannerName});
    }

    @Override
    public void setForceReprocess(boolean b) {
        this.forceReprocess = b;
    }

    @Override
    public boolean isForceReprocess() {
        return this.forceReprocess;
    }

    @Override
    public void setIncompleteOutputDestinations(Map<String, DocDestinationStatus> value) {
        this.incompleteOutputDestinations.clear();
        this.incompleteOutputDestinations.putAll(value);
        this.statusChange = null;
    }

    @Override
    public boolean alreadyHasIncompleteStepList() {
        return this.incompleteOutputDestinations.size() > 0;
    }

    @Override
    public boolean isPlanOutput(String stepName) {
        return this.incompleteOutputDestinations.containsKey(stepName);
    }

    @Override
    public String listIncompleteOutputSteps() {
        return String.join((CharSequence)",", this.incompleteOutputDestinations.keySet());
    }

    @Override
    public DocStatusChange getStatusChange() {
        return this.statusChange;
    }

    @Override
    public List<String> listChangingDestinations() {
        return this.statusReporter.getChangedDestinations(this.statusChange).stream().map(DocDestinationStatus::getOutputDestination).collect(Collectors.toList());
    }

    @Override
    public String[] getIncompleteOutputDestinations() {
        return (String[])this.incompleteOutputDestinations.keySet().toArray(String[]::new);
    }

    @Override
    public void setStatus(Status status, String message, Serializable ... args) {
        this.statusChange = new DocStatusChange(status, message, args);
    }

    @Override
    public void removeDownStreamOutputStep(Router router, String name) {
        Plan p;
        Step step;
        if ((router.getStep() == null || router.getStep().getPlan() == null) && (step = (p = router.getStep().getPlan()).findStep(this.getSourceScannerName())) == null) {
            throw new IllegalArgumentException("Nice try, you aren't supposed to call this from processors or other places that don't have access to a router that is actually part of the plan. Don't do this. If you persist and work around this exception, anything you break is your own problem, and NOT supported.You have been warned.");
        }
        log.trace("Removing destination step {} from {} after processing with {}", (Object)name, (Object)this.getId(), (Object)router.getStep().getName());
        if (this.incompleteOutputDestinations.remove(name) == null) {
            throw new RuntimeException("Tried to remove non-existent destination step! Router:" + router.getClass().getSimpleName() + " Step:" + name);
        }
    }

    @Override
    public String dumpStatus() {
        return String.valueOf(this.incompleteOutputDestinations);
    }

    @Override
    public String getOrigination() {
        return this.origination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllOtherDestinationsQuietly(Set<String> outputDestinationNames) {
        HashMap<String, DocDestinationStatus> removed = new HashMap<String, DocDestinationStatus>();
        Map<String, DocDestinationStatus> map = this.incompleteOutputDestinations;
        synchronized (map) {
            for (Map.Entry<String, DocDestinationStatus> destStat : this.incompleteOutputDestinations.entrySet()) {
                if (outputDestinationNames.contains(destStat.getKey())) continue;
                removed.put(destStat.getKey(), destStat.getValue());
            }
            for (String dest : removed.keySet()) {
                this.incompleteOutputDestinations.remove(dest);
            }
        }
    }

    private class StatusReporterImpl
    implements StatusReporter {
        private final Step step;

        private StatusReporterImpl(Step step) {
            this.step = step;
        }

        @Override
        public void reportStatus(Document doc) {
            if (!DocumentImpl.this.isStatusChanged()) {
                return;
            }
            DocStatusChange statusChange = DocumentImpl.this.getStatusChange();
            List<DocDestinationStatus> destinationChanges = this.getChangedDestinations(statusChange);
            if (!DocumentImpl.this.newDocAllowedToSetProcessingStatus && destinationChanges.stream().anyMatch(d -> d.getStatus() == Status.PROCESSING)) {
                throw new IllegalStateException("Attempted to change a document to processing status. This is only set when the document object is created");
            }
            DocumentImpl.this.newDocAllowedToSetProcessingStatus = false;
            String message = destinationChanges.stream().map(DocDestinationStatus::getMessage).collect(Collectors.joining("#,#"));
            Object[] params = destinationChanges.stream().flatMap(d -> Arrays.stream(d.getMessageParams())).toArray();
            try (DocumentLoggingContext dc = new DocumentLoggingContext(DocumentImpl.this);){
                dc.run(() -> log.info(Markers.FTI_MARKER, message, params));
            }
            catch (AppenderLoggingException e) {
                if (Main.isNotShuttingDown()) {
                    log.error("Could not contact our internal Cassandra!!!", (Throwable)e);
                }
                log.info("Shutdown prevented update {} ==> {}", (Object)DocumentImpl.this.getId(), (Object)DocumentImpl.this.getStatusChange());
            }
            for (DocDestinationStatus changed : destinationChanges) {
                if (changed.getStatus() == Status.PROCESSING || changed.getStatus() == Status.INDEXING || changed.getStatus() == Status.BATCHED) continue;
                DocumentImpl.this.incompleteOutputDestinations.remove(changed.getOutputDestination());
            }
            DocumentImpl.this.statusChange = null;
        }

        @Override
        public List<DocDestinationStatus> getChangedDestinations(DocStatusChange statusChange) {
            Collection<DocDestinationStatus> values = DocumentImpl.this.incompleteOutputDestinations.values();
            List<DocDestinationStatus> destinationChanges = values.stream().filter(v -> !statusChange.getStatus().isStepSpecific() || statusChange.getStatus().isStepSpecific() && this.step.isOutputDestinationThisStep(v.getOutputDestination())).filter(v -> statusChange.getSpecificDestinations() == null || statusChange.getSpecificDestinations().size() == 0 || statusChange.getSpecificDestinations().contains(v.getOutputDestination())).map(v -> new DocDestinationStatus(statusChange.getStatus(), v.getOutputDestination(), statusChange.getMessage(), (Serializable[])statusChange.getMessageParams())).collect(Collectors.toList());
            log.trace("Changing destinations:{} from {}", destinationChanges, values);
            return destinationChanges;
        }
    }
}

