/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.model.impl;

import com.google.common.collect.ArrayListMultimap;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jesterj.ingest.Main;
import org.jesterj.ingest.model.Active;
import org.jesterj.ingest.model.Configurable;
import org.jesterj.ingest.model.Plan;
import org.jesterj.ingest.model.Scanner;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.model.impl.CyclicGraphException;
import org.jesterj.ingest.model.impl.NamedBuilder;
import org.jesterj.ingest.model.impl.ScannerImpl;
import org.jesterj.ingest.model.impl.StepImpl;
import org.jetbrains.annotations.NotNull;

public class PlanImpl
implements Plan {
    private static final Logger log = LogManager.getLogger();
    private LinkedHashMap<String, Step> stepsMap;
    private String idField;
    private boolean active = false;
    private String name;
    private int planVersion;

    protected PlanImpl() {
    }

    @Override
    public Step[] getSteps() {
        return this.getStepsMap().values().toArray(new Step[0]);
    }

    @Override
    public Step[] getExecutableSteps() {
        return this.getStepsMap().values().toArray(new Step[0]);
    }

    @Override
    public String getDocIdField() {
        return this.getIdField();
    }

    @Override
    public Step findStep(String stepName) {
        if (stepName == null) {
            return null;
        }
        for (int i = 0; i < this.getSteps().length; ++i) {
            Step step = this.getSteps()[i];
            if (!stepName.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    @Override
    public Renderer visualize(Format format) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        ArrayList<Step> scanners = new ArrayList<Step>();
        for (Step step : this.getSteps()) {
            if (!(step instanceof Scanner)) continue;
            scanners.add(step);
        }
        ArrayList<String> linkedSteps = new ArrayList<String>();
        for (Step step : scanners) {
            this.linkUp(nodes, linkedSteps, (StepImpl)step);
        }
        Graph g = Factory.graph((String)"visualize").directed();
        for (Step scanner : scanners) {
            g = g.with(new LinkSource[]{(LinkSource)nodes.get(scanner.getName())});
        }
        Graphviz tmp = Graphviz.fromGraph((Graph)g);
        return tmp.render(format);
    }

    @Override
    public int getVersion() {
        return this.planVersion;
    }

    private void linkUp(Map<String, Node> nodes, List<String> knownSteps, StepImpl step) {
        LinkedHashMap<String, Step> nextSteps = step.getNextSteps();
        String label = PlanImpl.getLabel(step);
        Node node = nodes.computeIfAbsent(step.getName(), Factory::node);
        node = (Node)node.with(new Attributes[]{PlanImpl.nodeColor(step), Style.lineWidth((double)2.0), Style.FILLED, PlanImpl.nodeFillColor(step).fill(), Label.of((String)label)});
        nodes.replace(step.getName(), node);
        knownSteps.add(step.getName());
        if (nextSteps.size() == 0) {
            return;
        }
        for (Step subsequentStep : nextSteps.values()) {
            if (!knownSteps.contains(subsequentStep.getName())) {
                this.linkUp(nodes, knownSteps, (StepImpl)subsequentStep);
            }
            Node nextNode = nodes.get(subsequentStep.getName());
            node = node.link(new LinkTarget[]{nextNode});
            nodes.put(step.getName(), node);
        }
    }

    @NotNull
    private static Color nodeFillColor(StepImpl step) {
        if (step.getRouter() != null && !step.getRouter().isDeterministic()) {
            return Color.hsv((double)0.7, (double)0.3, (double)1.0);
        }
        if (step.getRouter() != null && step.getRouter().isDeterministic()) {
            return Color.rgb((String)"#AAFFAA");
        }
        return Color.WHITE;
    }

    @NotNull
    private static Color nodeColor(StepImpl step) {
        if (step instanceof Scanner) {
            return Color.BLUE;
        }
        if (step.getProcessor().isIdempotent()) {
            return Color.PLUM;
        }
        if (step.getNextSteps().isEmpty() || step.getProcessor().isPotent()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private static String getLabel(Step step) {
        if (step instanceof Scanner) {
            return step.getName();
        }
        if (step.getRouter() != null) {
            return String.format("%s/%s\n%s\n(%s)", step.size(), step.getBatchSize(), step.getName(), step.getRouter().getName());
        }
        return String.format("%s/%s\n%s", step.size(), step.getBatchSize(), step.getName());
    }

    @Override
    public synchronized void activate() {
        String planName = this.getName();
        log.info("Activating plan '{}'", (Object)planName);
        this.register();
        this.setActive(true);
        this.getStepsMap().values().parallelStream().forEach(Active::activate);
        log.info("Activation of plan {} complete", (Object)planName);
    }

    void register() {
        Main.registerPlan(this);
    }

    @Override
    public synchronized void deactivate() {
        LinkedHashSet<Step> nextLevel;
        if (!this.isActive()) {
            return;
        }
        log.info("Deactivating plan '{}'", (Object)this.getName());
        LinkedHashSet<Step> finalNextLevel = nextLevel = (LinkedHashSet<Step>)this.getStepsMap().values().stream().filter(s -> s instanceof Scanner).collect(Collectors.toCollection(LinkedHashSet::new));
        log.info("Scanners found: {}", new Supplier[]{() -> finalNextLevel.stream().map(Configurable::getName).collect(Collectors.toSet())});
        do {
            LinkedHashSet<Step> currentLevel = nextLevel;
            nextLevel = new LinkedHashSet<Step>();
            for (Step step : currentLevel) {
                if (step.isActive()) {
                    step.deactivate();
                }
                for (Step nextStep : step.getNextSteps().values()) {
                    this.deactivateStep(nextStep, nextLevel);
                }
            }
        } while (!nextLevel.isEmpty());
        this.setActive(false);
        Main.deregisterPlan(this);
    }

    private void deactivateStep(Step step, Set<Step> nextLevel) {
        if (step.isActivePriorSteps()) {
            nextLevel.add(step);
            return;
        }
        if (step.isActive()) {
            step.deactivate();
        }
        for (Step nextStep : step.getNextSteps().values()) {
            this.deactivateStep(nextStep, nextLevel);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Override
    public String getName() {
        return this.name;
    }

    LinkedHashMap<String, Step> getStepsMap() {
        return this.stepsMap;
    }

    void setStepsMap(LinkedHashMap<String, Step> stepsMap) {
        this.stepsMap = stepsMap;
    }

    String getIdField() {
        return this.idField;
    }

    void setIdField(String idField) {
        this.idField = idField;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    void setName(String name) {
        this.name = name;
    }

    public static class Builder
    extends NamedBuilder<Plan> {
        PlanImpl obj = new PlanImpl();
        LinkedHashMap<String, Step> steps = new LinkedHashMap();
        LinkedHashMap<String, StepImpl.Builder> builders = new LinkedHashMap();
        List<StepImpl.Builder> pendingBuilders = new ArrayList<StepImpl.Builder>();
        ArrayListMultimap<String, String> predecessors = ArrayListMultimap.create();

        public Builder addStep(StepImpl.Builder step, String ... predecessors) {
            if (!step.isValid()) {
                throw new RuntimeException("Invalid configuration for step " + step.getStepName());
            }
            if (!(predecessors != null && predecessors.length != 0 || step instanceof ScannerImpl.Builder)) {
                throw new IllegalArgumentException("Only scanners can have no predecessor");
            }
            if (this.builders.get(step.getStepName()) != null) {
                throw new IllegalArgumentException("Cannot add the same step twice. A step named " + step.getStepName() + " has already been added.");
            }
            this.builders.put(step.getStepName(), step);
            if (predecessors != null) {
                for (String predecessor : predecessors) {
                    if (!this.builders.containsKey(predecessor)) {
                        throw new IllegalArgumentException("Unknown Step as predecessor:" + predecessor);
                    }
                    this.predecessors.put((Object)step.getStepName(), (Object)predecessor);
                }
            }
            return this;
        }

        List<StepImpl.Builder> findScanners() {
            return this.builders.keySet().stream().filter(stepName -> !this.predecessors.keySet().contains(stepName)).map(stepName -> this.builders.get(stepName)).collect(Collectors.toList());
        }

        @Override
        public Plan build() {
            if (!this.isValid()) {
                throw new RuntimeException("Invalid configuration, cannot build plan named " + this.getObj().getName());
            }
            List<StepImpl.Builder> scanners = this.findScanners();
            scanners.forEach(this::buildStep);
            PlanImpl obj = this.getObj();
            this.obj = new PlanImpl();
            obj.setStepsMap(this.steps);
            for (Step step : this.steps.values()) {
                ((StepImpl)step).setPlan(obj);
            }
            return obj;
        }

        private void buildStep(StepImpl.Builder builder) {
            if (this.pendingBuilders.contains(builder)) {
                throw new CyclicGraphException("Step " + builder.getStepName() + " is referenced by one of it's descendants");
            }
            Set successors = this.predecessors.keySet().stream().filter(stepName -> this.predecessors.get(stepName).contains(builder.getStepName())).collect(Collectors.toSet());
            List unbuiltSuccessors = successors.stream().filter(stepName -> !this.steps.containsKey(stepName)).collect(Collectors.toList());
            if (unbuiltSuccessors.size() > 0) {
                this.pendingBuilders.add(builder);
                for (String unbuiltSuccessor : unbuiltSuccessors) {
                    this.buildStep((StepImpl.Builder)this.builders.remove(unbuiltSuccessor));
                }
            }
            for (String successor : successors) {
                builder.addNextStep(this.steps.get(successor));
            }
            StepImpl step = builder.build();
            String stepName2 = step.getName();
            this.steps.put(stepName2, step);
        }

        public Builder named(String name) {
            this.getObj().setName(name);
            return this;
        }

        public Builder withVersion(int version) {
            this.getObj().planVersion = version;
            return this;
        }

        @Override
        protected PlanImpl getObj() {
            return this.obj;
        }

        public Builder withIdField(String id) {
            this.getObj().setIdField(id);
            return this;
        }
    }
}

