/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.persistence;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.log4j.Logger;
import org.jesterj.ingest.persistence.CassandraConfig;
import org.jesterj.ingest.persistence.JJCassandraDaemon;
import org.yaml.snakeyaml.Yaml;

public class Cassandra {
    private static CassandraDaemon cassandra;
    private static final ConcurrentLinkedQueue<RunnableFuture> finalBootActions;
    private static String listenAddress;
    private static Object log;
    private static volatile boolean booting;
    private static volatile boolean stopping;

    public static boolean isBooting() {
        return booting;
    }

    public static void start(File cassandraDir) {
        Cassandra.start(cassandraDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(File cassandraDir, String listenAddress) {
        System.out.println("Booting internal cassandra");
        boolean firstBoot = false;
        try {
            File triggers = new File(cassandraDir, "triggers");
            System.setProperty("cassandra.triggers_dir", triggers.getCanonicalPath());
            if (!cassandraDir.exists()) {
                System.out.println("CREATING NEW cassandra directory.");
                if (!cassandraDir.mkdirs() && triggers.mkdirs()) {
                    throw new RuntimeException("could not create" + cassandraDir);
                }
            }
            File yaml = new File(cassandraDir, "cassandra.yaml");
            String confURI = yaml.toURI().toString();
            System.setProperty("cassandra.config", confURI);
            System.out.println("Using cassandra config file at: " + confURI);
            if (!yaml.exists()) {
                firstBoot = true;
                CassandraConfig cfg = new CassandraConfig(cassandraDir.getCanonicalPath());
                if (listenAddress == null) {
                    cfg.guessIp();
                } else {
                    cfg.setListen_address(listenAddress);
                }
                String cfgStr = new Yaml().dumpAsMap((Object)cfg);
                System.out.println("FIRST TIME STARTUP: writing default config to " + yaml.toPath());
                System.out.println(cfgStr);
                Files.write(yaml.toPath(), cfgStr.getBytes(), StandardOpenOption.CREATE);
            }
            YamlConfigurationLoader cl = new YamlConfigurationLoader();
            Config conf = cl.loadConfig();
            System.out.println("CASSANDRA DIR:" + cassandraDir);
            try {
                ServerSocket s = new ServerSocket(0);
                int freePort = s.getLocalPort();
                s.close();
                ServerSocketChannel testSocket = ServerSocketChannel.open();
                InetSocketAddress addr = new InetSocketAddress(conf.listen_address, freePort);
                testSocket.bind(addr);
                testSocket.close();
            }
            catch (BindException e) {
                System.out.println("WARNING: ipAddress has changed, temporarily picking new address");
                CassandraConfig cfg = new CassandraConfig(cassandraDir.getCanonicalPath());
                cfg.guessIp();
                conf.listen_address = cfg.getListen_address();
            }
            Cassandra.listenAddress = conf.listen_address;
            System.out.println("Listen Address:" + conf.listen_address);
        }
        catch (IOException | ConfigurationException e) {
            e.printStackTrace();
        }
        cassandra = new JJCassandraDaemon();
        try {
            System.setProperty("cassandra-foreground", "true");
            cassandra.activate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (firstBoot) {
            try {
                System.out.println("First time startup... waiting for Cassandra to create it's default roles");
                Thread.sleep((long)((double)AuthKeyspace.SUPERUSER_SETUP_DELAY * 1.1));
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted during startup");
            }
        }
        System.out.println("Starting final boot actions (" + finalBootActions.size() + ")");
        ConcurrentLinkedQueue<RunnableFuture> concurrentLinkedQueue = finalBootActions;
        synchronized (concurrentLinkedQueue) {
            while (finalBootActions.peek() != null) {
                ((RunnableFuture)finalBootActions.remove()).run();
            }
            booting = false;
        }
        System.out.println("Cassandra booted");
    }

    public static String getListenAddress() {
        return listenAddress;
    }

    public static InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(listenAddress, 9042);
    }

    public static void stop() {
        stopping = true;
        booting = true;
        log = null;
        cassandra.stop();
        cassandra.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Future<T> whenBooted(Callable<T> callable) {
        FutureTask<T> t = new FutureTask<T>(callable);
        ConcurrentLinkedQueue<RunnableFuture> concurrentLinkedQueue = finalBootActions;
        synchronized (concurrentLinkedQueue) {
            if (Cassandra.isBooting()) {
                finalBootActions.add(t);
            } else {
                t.run();
            }
        }
        return t;
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        Cassandra.start(file);
    }

    public static void printErrors(ResultSet rs) {
        for (Map.Entry error : rs.getExecutionInfo().getErrors()) {
            String message = error.getKey() + ":" + error.getValue();
            if (booting) {
                System.out.println(message);
                continue;
            }
            if (log == null) {
                try {
                    Class<?> logManagerClass = Class.forName("org.apache.logging.log4j.LogManager");
                    Method getLogger = logManagerClass.getMethod("getLogger", new Class[0]);
                    log = getLogger.invoke(logManagerClass, new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    System.out.println("Failed to instantiate logger in Cassandra.java:" + e.getMessage());
                }
            }
            if (log == null) continue;
            ((Logger)log).error((Object)message, (Throwable)error.getValue());
        }
    }

    public static boolean isStopping() {
        return stopping;
    }

    static {
        System.setProperty("cassandra.native.epoll.enabled", "false");
        finalBootActions = new ConcurrentLinkedQueue();
        booting = true;
        stopping = false;
    }
}

