/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.persistence;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Optional;
import java.util.SplittableRandom;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jesterj.ingest.persistence.Cassandra;
import org.jesterj.ingest.persistence.JJCassandraDaemon;

public class CassandraSupport {
    public static final SplittableRandom rootRand = new SplittableRandom();
    public static final ThreadLocal<SplittableRandom> antiCollision = ThreadLocal.withInitial(rootRand::split);
    private static final Map<String, Future<PreparedStatement>> preparedQueries = new ConcurrentHashMap<String, Future<PreparedStatement>>();
    public static NonClosableSession NON_CLOSABLE_SESSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<PreparedStatement> addStatement(String name, String statement) {
        Map<String, Future<PreparedStatement>> map = preparedQueries;
        synchronized (map) {
            if (!preparedQueries.containsKey(name)) {
                Future<PreparedStatement> result = Cassandra.whenBooted(() -> this.getSession().prepare(statement));
                preparedQueries.put(name, result);
                return result;
            }
        }
        return null;
    }

    public CqlSession getSession() {
        if (NON_CLOSABLE_SESSION == null && Cassandra.getListenAddress() != null) {
            NON_CLOSABLE_SESSION = new NonClosableSession();
        }
        if (NON_CLOSABLE_SESSION == null) {
            System.out.println("WARNING: returning null session!!");
        }
        return NON_CLOSABLE_SESSION;
    }

    public PreparedStatement getPreparedQuery(String qName) {
        try {
            Future<PreparedStatement> preparedStatementFuture = preparedQueries.get(qName);
            return preparedStatementFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public PreparedStatement getPreparedQuery(String qName, String q) {
        try {
            Future<PreparedStatement> preparedStatementFuture = preparedQueries.get(qName);
            if (preparedStatementFuture != null) {
                return preparedStatementFuture.get();
            }
            this.addStatement(qName, q);
            return preparedQueries.get(qName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<Object> whenBooted(Callable<Object> makeTables) {
        return Cassandra.whenBooted(makeTables);
    }

    public static class NonClosableSession
    implements CqlSession {
        private final Session sessionRef = SessionHolder.INSTANCE;

        public CompletionStage<Void> closeAsync() {
            throw new UnsupportedOperationException("Do not close the sessions handed out from CassandraSupport");
        }

        @NonNull
        public CompletionStage<Void> forceCloseAsync() {
            throw new UnsupportedOperationException("Do not close the sessions handed out from CassandraSupport");
        }

        public void close() {
            throw new UnsupportedOperationException("Do not close the sessions handed out from CassandraSupport");
        }

        @NonNull
        public CompletionStage<Void> closeFuture() {
            throw new UnsupportedOperationException("Do not close the sessions handed out from CassandraSupport");
        }

        public boolean isClosed() {
            return this.sessionRef.isClosed();
        }

        public void deactivate() {
            System.out.println("CLOSING CASSANDRA:");
            Thread.dumpStack();
            this.sessionRef.close();
        }

        @NonNull
        public String getName() {
            return this.sessionRef.getName();
        }

        @NonNull
        public Metadata getMetadata() {
            return this.sessionRef.getMetadata();
        }

        public boolean isSchemaMetadataEnabled() {
            return this.sessionRef.isSchemaMetadataEnabled();
        }

        @NonNull
        public CompletionStage<Metadata> setSchemaMetadataEnabled(@Nullable Boolean newValue) {
            return this.sessionRef.setSchemaMetadataEnabled(newValue);
        }

        @NonNull
        public CompletionStage<Metadata> refreshSchemaAsync() {
            return this.sessionRef.refreshSchemaAsync();
        }

        @NonNull
        public CompletionStage<Boolean> checkSchemaAgreementAsync() {
            return this.sessionRef.checkSchemaAgreementAsync();
        }

        @NonNull
        public DriverContext getContext() {
            return this.sessionRef.getContext();
        }

        @NonNull
        public Optional<CqlIdentifier> getKeyspace() {
            return this.sessionRef.getKeyspace();
        }

        @NonNull
        public Optional<Metrics> getMetrics() {
            return this.sessionRef.getMetrics();
        }

        @Nullable
        public <RequestT extends Request, ResultT> ResultT execute(@NonNull RequestT request, @NonNull GenericType<ResultT> resultType) {
            return (ResultT)this.sessionRef.execute(request, resultType);
        }
    }

    private static class SessionHolder {
        private static final Session INSTANCE;

        private SessionHolder() {
        }

        static {
            Session instance = null;
            try {
                instance = (Session)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(Cassandra.getSocketAddress())).withLocalDatacenter("datacenter1")).withAuthCredentials("cassandra", JJCassandraDaemon.getPwDefault())).build();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                INSTANCE = instance;
            }
        }
    }
}

