/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.persistence;

import java.io.File;
import java.util.UUID;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.NativeLibrary;
import org.jesterj.ingest.persistence.JJCassandraRoleManager;

public class JJCassandraDaemon
extends CassandraDaemon {
    public static final String MBEAN_NAME = "org.jesterj.cassandra.db:type=NativeAccess";
    private static String PW_DEFAULT = "cassandra";
    private final boolean runManaged = true;

    public JJCassandraDaemon() {
        super(true);
    }

    public static void defaultPassword(String newDefault) {
        PW_DEFAULT = PW_DEFAULT.equals("cassandra") ? newDefault : JJCassandraDaemon.throwOnSubsequentChange();
    }

    private static String throwOnSubsequentChange() {
        throw new IllegalStateException("Default password can only be changed once");
    }

    static String getPwDefault() {
        return PW_DEFAULT;
    }

    private void exitOrFail(String message, Throwable cause) {
        RuntimeException t = cause != null ? new RuntimeException(message, cause) : new RuntimeException(message);
        throw t;
    }

    public void stop() {
        super.stop();
        ActiveRepairService.instance.stop();
    }

    public void activate() {
        try {
            this.applyConfig();
            DatabaseDescriptor.setRoleManager((IRoleManager)new JJCassandraRoleManager(PW_DEFAULT));
            JJCassandraDaemon.registerNativeAccess();
            this.setup();
            String pidFile = CassandraRelevantProperties.CASSANDRA_PID_FILE.getString();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (CassandraRelevantProperties.CASSANDRA_FOREGROUND.getString() == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
            System.out.println("Startup complete");
        }
        catch (Throwable e) {
            boolean logStackTrace = !(e instanceof ConfigurationException) || ((ConfigurationException)e).logStackTrace;
            System.out.println("Exception (" + e.getClass().getName() + ") encountered during startup: " + e.getMessage());
            if (logStackTrace) {
                System.err.println("Exception encountered during startup" + e);
                e.printStackTrace();
                this.exitOrFail("Exception encountered during startup", e);
            }
            System.err.println("Exception encountered during startup: {}" + e.getMessage());
            e.printStackTrace();
            System.err.println(e.getMessage());
            this.exitOrFail("Exception encountered during startup: " + e.getMessage(), null);
        }
    }

    public static void registerNativeAccess() throws NotCompliantMBeanException {
        MBeanWrapper.instance.registerMBean((Object)new StandardMBean(new NativeAccess(), NativeAccessMBean.class), MBEAN_NAME + UUID.randomUUID(), MBeanWrapper.OnException.LOG);
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        public boolean isAvailable() {
            return NativeLibrary.isAvailable();
        }

        public boolean isMemoryLockable() {
            return NativeLibrary.jnaMemoryLockable();
        }
    }
}

