/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.persistence;

import org.apache.cassandra.auth.CassandraRoleManager;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang3.StringUtils;
import org.mindrot.jbcrypt.BCrypt;

public class JJCassandraRoleManager
extends CassandraRoleManager {
    private final String defaultSuperuserPassword;
    private static final int GENSALT_LOG2_ROUNDS = JJCassandraRoleManager.getGensaltLogRounds();

    public JJCassandraRoleManager(String pw) {
        this.defaultSuperuserPassword = pw;
    }

    public void setup() {
        this.loadRoleStatement();
        this.scheduleSetupTask(() -> {
            this.setupDefaultRoleJJ();
            return null;
        });
    }

    private void setupDefaultRoleJJ() {
        if (StorageService.instance.getTokenMetadata().sortedTokens().isEmpty()) {
            throw new IllegalStateException("CassandraRoleManager skipped default role setup: no known tokens in ring");
        }
        if (!JJCassandraRoleManager.hasExistingRoles()) {
            QueryProcessor.process((String)this.createJJDefaultRoleQuery(), (ConsistencyLevel)JJCassandraRoleManager.consistencyForRoleWrite((String)"cassandra"));
        }
    }

    private String createJJDefaultRoleQuery() {
        return String.format("INSERT INTO %s.%s (role, is_superuser, can_login, salted_hash) VALUES ('%s', true, true, '%s') USING TIMESTAMP 0", "system_auth", "roles", "cassandra", JJCassandraRoleManager.escape(JJCassandraRoleManager.hashpw(this.defaultSuperuserPassword)));
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static String hashpw(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)GENSALT_LOG2_ROUNDS));
    }

    static int getGensaltLogRounds() {
        int rounds = Integer.getInteger("cassandra.auth_bcrypt_gensalt_log2_rounds", 10);
        if (rounds < 4 || rounds > 30) {
            throw new ConfigurationException(String.format("Bad value for system property -D%s.Please use a value between 4 and 30 inclusively", "cassandra.auth_bcrypt_gensalt_log2_rounds"));
        }
        return rounds;
    }
}

