/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import com.copyright.easiertest.SimpleProperty;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class CopyField
implements DocumentProcessor {
    static Logger log = LogManager.getLogger();
    private String from;
    private String into;
    private boolean retainOriginal = true;
    private String name;

    @Override
    public Document[] processDocument(Document document) {
        List<String> values = document.get(this.getFrom());
        document.putAll(this.getInto(), values);
        if (!this.isRetainOriginal()) {
            document.removeAll(this.getFrom());
        }
        log.trace("After Copy Result at destination is {}", new Supplier[]{() -> document.get(this.getInto())});
        return new Document[]{document};
    }

    @SimpleProperty
    public String getFrom() {
        return this.from;
    }

    @SimpleProperty
    public String getInto() {
        return this.into;
    }

    @SimpleProperty
    public boolean isRetainOriginal() {
        return this.retainOriginal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<CopyField> {
        CopyField obj = new CopyField();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected CopyField getObj() {
            return this.obj;
        }

        public Builder from(String from) {
            this.getObj().from = from;
            return this;
        }

        public Builder into(String into) {
            this.getObj().into = into;
            return this;
        }

        public Builder retainingOriginal(boolean retain) {
            this.getObj().retainOriginal = retain;
            return this;
        }

        private void setObj(CopyField obj) {
            this.obj = obj;
        }

        @Override
        public CopyField build() {
            CopyField object = this.getObj();
            this.setObj(new CopyField());
            return object;
        }
    }
}

