/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.Closeable;
import java.util.stream.Collectors;
import org.apache.logging.log4j.ThreadContext;
import org.jesterj.ingest.model.Document;

public class DocumentLoggingContext
implements Closeable {
    public DocumentLoggingContext(Document d) {
        for (ContextNames name : ContextNames.values()) {
            String val = name.fromDoc(d);
            ThreadContext.put((String)String.valueOf((Object)name), (String)val);
        }
    }

    public void run(Runnable r) {
        try (DocumentLoggingContext documentLoggingContext = this;){
            r.run();
        }
    }

    @Override
    public void close() {
        for (ContextNames value : ContextNames.values()) {
            ThreadContext.remove((String)String.valueOf((Object)value));
        }
    }

    public static enum ContextNames {
        JJ_DOC_ID{

            @Override
            String fromDoc(Document d) {
                return d.getId();
            }
        }
        ,
        JJ_DOC_HASH{

            @Override
            String fromDoc(Document d) {
                return d.getHash();
            }
        }
        ,
        JJ_SCANNER_NAME{

            @Override
            String fromDoc(Document d) {
                return d.getSourceScannerName();
            }
        }
        ,
        JJ_PARENT_ID{

            @Override
            String fromDoc(Document d) {
                return d.getParentId();
            }
        }
        ,
        JJ_ORIG_PARENT_ID{

            @Override
            String fromDoc(Document d) {
                return d.getOrignalParentId();
            }
        }
        ,
        JJ_OUTPUT_STEP_CHANGES{

            @Override
            String fromDoc(Document d) {
                return String.join((CharSequence)",", d.listChangingDestinations());
            }
        }
        ,
        JJ_STATUS_CHANGES{

            @Override
            String fromDoc(Document d) {
                return d.listChangingDestinations().stream().map(dest -> d.getStatusChange().getStatus().toString()).collect(Collectors.joining(","));
            }
        };


        abstract String fromDoc(Document var1);
    }
}

