/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import com.copyright.easiertest.SimpleProperty;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class FetchUrl
implements DocumentProcessor {
    private static final Logger log = LogManager.getLogger();
    private String linkField;
    private boolean failOnIOError;
    private String name;
    Cache<String, Long> visitedSiteCache = CacheBuilder.newBuilder().maximumSize(50000L).build();
    private long throttleMs;
    private String errorField;
    private String httpStatusField;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;

    @Override
    public Document[] processDocument(Document document) {
        block12: {
            URL url = null;
            try {
                url = new URL(document.getFirstValue(this.linkField));
                String protocol = url.getProtocol();
                String server = url.getHost();
                Long lastAccess = (Long)this.visitedSiteCache.getIfPresent((Object)server);
                long now = System.currentTimeMillis();
                if (lastAccess == null) {
                    this.visitedSiteCache.put((Object)server, (Object)now);
                } else {
                    long elapsed = now - lastAccess;
                    if (elapsed < this.throttleMs) {
                        try {
                            Thread.sleep(this.throttleMs - elapsed);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(this.connectionTimeout);
                conn.setReadTimeout(this.readTimeout);
                conn.connect();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if ("http".equals(protocol) || "https".equals(protocol)) {
                    HttpURLConnection httpConnection = (HttpURLConnection)conn;
                    int responseCode = httpConnection.getResponseCode();
                    if (this.httpStatusField != null) {
                        document.put(this.httpStatusField, String.valueOf(responseCode));
                    }
                    if (responseCode >= 400) {
                        String message = "HTTP server responded " + responseCode + " " + httpConnection.getResponseMessage();
                        if (this.errorField != null) {
                            document.put(this.errorField, message);
                        }
                        throw new IOException(message);
                    }
                }
                IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)baos);
                document.setRawData(baos.toByteArray());
            }
            catch (IOException e) {
                if (this.failOnIOError) {
                    throw new RuntimeException(e);
                }
                log.warn("Could not fetch " + url + " for " + document.getId(), (Throwable)e);
                if (this.errorField == null) break block12;
                document.put(this.errorField, e.getMessage());
            }
        }
        return new Document[]{document};
    }

    @SimpleProperty
    public String getLinkField() {
        return this.linkField;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<FetchUrl> {
        FetchUrl obj = new FetchUrl();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected FetchUrl getObj() {
            return this.obj;
        }

        public Builder fromLinkIn(String from) {
            this.getObj().linkField = from;
            return this;
        }

        public Builder reportErrorsIn(String errorField) {
            this.getObj().errorField = errorField;
            return this;
        }

        public Builder reportHttpStatusIn(String statusField) {
            this.getObj().httpStatusField = statusField;
            return this;
        }

        public Builder sameSiteAccessOncePer(long miliseconds) {
            this.getObj().throttleMs = miliseconds;
            return this;
        }

        public Builder withSiteCachSize(long numSites) {
            this.getObj().visitedSiteCache = CacheBuilder.newBuilder().maximumSize(numSites).build();
            return this;
        }

        public Builder failDocOnError(boolean fail) {
            this.getObj().failOnIOError = fail;
            return this;
        }

        public Builder withConnectionTimeOut(int timeOut) {
            this.getObj().connectionTimeout = timeOut;
            return this;
        }

        public Builder withReadTimeOut(int timeOut) {
            this.getObj().readTimeout = timeOut;
            return this;
        }

        private void setObj(FetchUrl obj) {
            this.obj = obj;
        }

        @Override
        public FetchUrl build() {
            FetchUrl object = this.getObj();
            this.setObj(new FetchUrl());
            return object;
        }
    }
}

