/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class FieldTemplateProcessor
implements DocumentProcessor {
    private String name;
    private String templateField;
    private final VelocityEngine engine = new VelocityEngine();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document[] processDocument(Document document) {
        VelocityContext velocityContext = new VelocityContext(new HashMap<String, Collection<String>>(document.asMap()));
        List<String> values = document.removeAll(this.templateField);
        for (String value : values) {
            StringWriter writer = new StringWriter();
            this.engine.evaluate((Context)velocityContext, (Writer)writer, document.getId(), value);
            document.put(this.templateField, writer.toString());
        }
        return new Document[]{document};
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTemplateField(String templateField) {
        this.templateField = templateField;
    }

    public static class Builder
    extends NamedBuilder<FieldTemplateProcessor> {
        FieldTemplateProcessor obj = new FieldTemplateProcessor();

        public Builder named(String name) {
            this.getObj().setName(name);
            return this;
        }

        @Override
        protected FieldTemplateProcessor getObj() {
            return this.obj;
        }

        public Builder withTemplatesIn(String fieldName) {
            this.getObj().setTemplateField(fieldName);
            return this;
        }

        private void setObj(FieldTemplateProcessor obj) {
            this.obj = obj;
        }

        @Override
        public FieldTemplateProcessor build() {
            FieldTemplateProcessor object = this.getObj();
            this.setObj(new FieldTemplateProcessor());
            return object;
        }
    }
}

