/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class LogAndDrop
implements DocumentProcessor {
    static Logger log = LogManager.getLogger();
    private Level level;
    private String name;

    protected LogAndDrop() {
    }

    @Override
    public Document[] processDocument(Document document) {
        log.log(this.getLevel(), document.toString());
        document.setStatus(Status.DROPPED, "Intentional drop by LogAndDrop processor {}", new Serializable[]{this.getName()});
        return new Document[]{document};
    }

    Level getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<LogAndDrop> {
        LogAndDrop obj = new LogAndDrop();

        public Builder withLogLevel(Level level) {
            this.getObj().level = level;
            return this;
        }

        @Override
        protected LogAndDrop getObj() {
            return this.obj;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        private void setObj(LogAndDrop obj) {
            this.obj = obj;
        }

        @Override
        public LogAndDrop build() {
            LogAndDrop object = this.getObj();
            this.setObj(new LogAndDrop());
            return object;
        }
    }
}

