/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class LogAndFail
implements DocumentProcessor {
    static Logger log = LogManager.getLogger();
    private Level level;
    private String name;
    private RuntimeException exception;
    private int afterNumCalls;
    private final AtomicInteger calls = new AtomicInteger(0);

    protected LogAndFail() {
    }

    @Override
    public Document[] processDocument(Document document) {
        if (this.getCalls().getAndIncrement() >= this.getAfterNumCalls()) {
            if (this.getException() != null && this.getLevel() != null) {
                log.log(this.getLevel(), (Object)this.getException());
                throw this.getException();
            }
            RuntimeException e = new RuntimeException("Intentional failure by LogAndFail processor " + this.getName());
            log.info((Object)e);
            throw e;
        }
        log.log(this.getLevel(), document.toString());
        return new Document[]{document};
    }

    Level getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getAfterNumCalls() {
        return this.afterNumCalls;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public AtomicInteger getCalls() {
        return this.calls;
    }

    public static class Builder
    extends NamedBuilder<LogAndFail> {
        LogAndFail obj = new LogAndFail();

        public Builder withLogLevel(Level level) {
            this.getObj().level = level;
            return this;
        }

        public Builder throwing(RuntimeException t) {
            this.getObj().exception = t;
            return this;
        }

        public Builder after(int calls) {
            this.getObj().afterNumCalls = calls;
            return this;
        }

        @Override
        protected LogAndFail getObj() {
            return this.obj;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        private void setObj(LogAndFail obj) {
            this.obj = obj;
        }

        @Override
        public LogAndFail build() {
            LogAndFail object = this.getObj();
            this.setObj(new LogAndFail());
            return object;
        }
    }
}

