/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class NoOpProcessor
implements DocumentProcessor {
    private static final AtomicInteger count = new AtomicInteger(0);
    static volatile Logger log = LogManager.getLogger();
    private String name = "default_processor" + count.getAndIncrement();
    private boolean warn = true;

    @Override
    public Document[] processDocument(Document document) {
        if (this.isWarn()) {
            log.warn("Default processor in use, this is usually not the intention");
        }
        return new Document[]{document};
    }

    public boolean isWarn() {
        return this.warn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<NoOpProcessor> {
        NoOpProcessor obj = new NoOpProcessor();

        @Override
        protected NoOpProcessor getObj() {
            return this.obj;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder turnOffWarning() {
            this.getObj().warn = false;
            return this;
        }

        private void setObj(NoOpProcessor obj) {
            this.obj = obj;
        }

        @Override
        public NoOpProcessor build() {
            NoOpProcessor object = this.getObj();
            this.setObj(new NoOpProcessor());
            return object;
        }
    }
}

