/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.schema.FieldType;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;
import org.jesterj.ingest.utils.ClassSubPathResourceLoader;
import org.jesterj.ingest.utils.SolrSchemaUtil;
import org.xml.sax.SAXException;

public class PreAnalyzeFields
implements DocumentProcessor {
    private static final Logger log = LogManager.getLogger();
    private final ThreadLocal<Analyzer> analyzer = new ThreadLocal<Analyzer>(){

        @Override
        protected Analyzer initialValue() {
            try {
                return PreAnalyzeFields.this.analyzerFactory.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private Supplier<ClassLoader> classLoaderProvider = new Supplier<ClassLoader>(){

        @Override
        public ClassLoader get() {
            return this.getClass().getClassLoader();
        }
    };
    private ClassSubPathResourceLoader loader;
    private Callable<Analyzer> analyzerFactory;
    private String name;
    private final List<String> fieldsToAnalyze = new ArrayList<String>();
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Document[] processDocument(Document document) {
        for (String docFieldName : this.fieldsToAnalyze) {
            List<String> values = document.get(docFieldName);
            ArrayList<String> jsonValues = new ArrayList<String>(values.size());
            for (String value : values) {
                HashMap<String, Object> tokOutput = new HashMap<String, Object>();
                tokOutput.put("v", "1");
                tokOutput.put("str", value);
                ArrayList tokens = new ArrayList();
                tokOutput.put("tokens", tokens);
                try {
                    TokenStream ts = this.analyzer.get().tokenStream(docFieldName, value);
                    try {
                        ts.reset();
                        OffsetAttribute offsetA = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
                        CharTermAttribute charTermA = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
                        PositionIncrementAttribute posIncA = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
                        PayloadAttribute payloadA = (PayloadAttribute)ts.getAttribute(PayloadAttribute.class);
                        TypeAttribute typeA = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
                        FlagsAttribute flagsA = (FlagsAttribute)ts.getAttribute(FlagsAttribute.class);
                        while (ts.incrementToken()) {
                            BytesRef payload;
                            HashMap<String, Object> tokAttrs = new HashMap<String, Object>();
                            char[] termChars = new char[charTermA.length()];
                            System.arraycopy(charTermA.buffer(), 0, termChars, 0, charTermA.length());
                            tokAttrs.put("t", new String(termChars));
                            tokAttrs.put("s", offsetA.startOffset());
                            tokAttrs.put("e", offsetA.endOffset());
                            tokAttrs.put("i", posIncA.getPositionIncrement());
                            Base64.Encoder encoder = Base64.getEncoder();
                            if (payloadA != null && (payload = payloadA.getPayload()) != null) {
                                tokAttrs.put("p", encoder.encode(payload.bytes));
                            }
                            tokAttrs.put("y", typeA.type());
                            if (flagsA != null) {
                                tokAttrs.put("f", Integer.toString(flagsA.getFlags(), 16));
                            }
                            tokens.add(tokAttrs);
                        }
                        ts.end();
                        jsonValues.add(this.mapper.writeValueAsString(tokOutput));
                    }
                    finally {
                        if (ts == null) continue;
                        ts.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            document.removeAll(docFieldName);
            document.putAll(docFieldName, jsonValues);
        }
        return new Document[]{document};
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<PreAnalyzeFields> {
        PreAnalyzeFields obj = new PreAnalyzeFields();
        private String typeName;
        private String luceneMatch = Version.LATEST.toString();
        private String schemaFile = "schema.xml";
        private float schemaVersion;

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder preAnalyzingField(String field) {
            this.getObj().fieldsToAnalyze.add(field);
            return this;
        }

        public Builder forTypeNamed(String name) {
            this.typeName = name;
            return this;
        }

        public Builder withLuceneMatchVersion(String version) {
            this.luceneMatch = version;
            return this;
        }

        public Builder loadingResourcesVia(Supplier<ClassLoader> provider) {
            this.getObj().classLoaderProvider = provider;
            return this;
        }

        public Builder fromFile(String filename) {
            this.schemaFile = filename;
            return this;
        }

        public Builder withSchemaVersion(float version) {
            this.schemaVersion = version;
            return this;
        }

        @Override
        protected PreAnalyzeFields getObj() {
            return this.obj;
        }

        private void setObj(PreAnalyzeFields obj) {
            this.obj = obj;
        }

        @Override
        public PreAnalyzeFields build() {
            SolrSchemaUtil util = new SolrSchemaUtil();
            try {
                String subpath;
                int endIndex = this.schemaFile.lastIndexOf("/");
                if (endIndex > 0) {
                    subpath = this.schemaFile.substring(0, endIndex + 1);
                    this.schemaFile = this.schemaFile.substring(endIndex + 1);
                } else {
                    subpath = "";
                }
                this.obj.loader = new ClassSubPathResourceLoader(this.obj.classLoaderProvider.get(), subpath);
                org.w3c.dom.Document doc = util.getSchemaDocument(this.schemaFile, this.obj.loader);
                FieldType ft = util.getFieldType(doc, this.typeName, this.luceneMatch, this.schemaVersion, this.obj.loader);
                this.obj.analyzerFactory = () -> ((FieldType)ft).getIndexAnalyzer();
            }
            catch (IOException | IllegalAccessException | InstantiationException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new RuntimeException(e);
            }
            PreAnalyzeFields built = this.getObj();
            this.setObj(new PreAnalyzeFields());
            return built;
        }
    }
}

