/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class RegexValueReplace
implements DocumentProcessor {
    private String name;
    private String field;
    private Pattern regex;
    private String replace;
    private boolean discardUnmatched = false;

    @Override
    public Document[] processDocument(Document document) {
        List<String> values = document.get(this.getField());
        ArrayList<String> newValues = new ArrayList<String>();
        for (String value : values) {
            Matcher m = this.getRegex().matcher(value);
            if (this.isDiscardUnmatched()) {
                if (!m.matches()) continue;
                newValues.add(m.replaceAll(this.getReplace()));
                continue;
            }
            newValues.add(m.replaceAll(this.getReplace()));
        }
        document.replaceValues(this.getField(), newValues);
        return new Document[]{document};
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getField() {
        return this.field;
    }

    protected void setField(String field) {
        this.field = field;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    protected void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public String getReplace() {
        return this.replace;
    }

    protected void setReplace(String replace) {
        this.replace = replace;
    }

    public boolean isDiscardUnmatched() {
        return this.discardUnmatched;
    }

    public void setDiscardUnmatched(boolean discardUnmatched) {
        this.discardUnmatched = discardUnmatched;
    }

    public static class Builder
    extends NamedBuilder<RegexValueReplace> {
        RegexValueReplace obj = new RegexValueReplace();

        public Builder named(String name) {
            this.getObj().setName(name);
            return this;
        }

        @Override
        protected RegexValueReplace getObj() {
            return this.obj;
        }

        public Builder editingField(String fieldName) {
            this.getObj().setField(fieldName);
            return this;
        }

        public Builder withRegex(String regex) {
            this.getObj().setRegex(Pattern.compile(regex));
            return this;
        }

        public Builder andReplacement(String replace) {
            this.getObj().setReplace(replace);
            return this;
        }

        public Builder discardingUnmatched() {
            this.getObj().discardUnmatched = true;
            return this;
        }

        private void setObj(RegexValueReplace obj) {
            this.obj = obj;
        }

        @Override
        public RegexValueReplace build() {
            RegexValueReplace object = this.getObj();
            this.setObj(new RegexValueReplace());
            return object;
        }
    }
}

