/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.cassandra.utils.ConcurrentBiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.processors.BatchProcessor;

public class SendToSolrCloudProcessor
extends BatchProcessor<SolrInputDocument>
implements DocumentProcessor {
    private static final Logger log = LogManager.getLogger();
    private String collection;
    private String textContentField = "content";
    private String fieldsField;
    private Map<String, String> params;
    private CloudSolrClient solrClient;
    private String name;

    protected SendToSolrCloudProcessor() {
    }

    public Logger log() {
        return log;
    }

    @Override
    protected void perDocFailLogging(Exception e, Document doc) {
        doc.setStatus(Status.ERROR, "{} could not be sent to solr because of {}", new Serializable[]{doc.getId(), e.getMessage()});
        doc.reportDocStatus();
        this.log().error("Error communicating with solr!", (Throwable)e);
    }

    @Override
    public boolean isPotent() {
        return true;
    }

    @Override
    protected void individualFallbackOperation(ConcurrentBiMap<Document, SolrInputDocument> oldBatch, Exception e) {
        for (Document document : oldBatch.keySet()) {
            this.createDocContext(document).run(() -> {
                try {
                    SolrInputDocument doc = (SolrInputDocument)oldBatch.get((Object)document);
                    if (doc instanceof Delete) {
                        document.setStatus(Status.INDEXING, "{} is being deleted from solr", new Serializable[]{document.getId()});
                        document.reportDocStatus();
                        this.getSolrClient().deleteById(((Document)oldBatch.inverse().get(doc)).getId());
                        document.setStatus(Status.INDEXED, "{} deleted from solr successfully", new Serializable[]{document.getId()});
                    } else {
                        document.setStatus(Status.INDEXING, "{} is being sent to solr", new Serializable[]{document.getId()});
                        document.reportDocStatus();
                        this.getSolrClient().add(doc);
                        document.setStatus(Status.INDEXED, "{} sent to solr successfully", new Serializable[]{document.getId()});
                    }
                }
                catch (IOException | SolrServerException e1) {
                    document.setStatus(Status.ERROR, "{} could not be sent to solr because of {}", new Serializable[]{document.getId(), e1.getMessage()});
                    this.log().error("Error sending to solr!", e1);
                }
                document.reportDocStatus();
            });
        }
    }

    @Override
    protected void batchOperation(ConcurrentBiMap<Document, SolrInputDocument> oldBatch) throws SolrServerException, IOException {
        List<Document> documentsToDelete;
        List<Document> documentsToAdd = oldBatch.keySet().stream().filter(doc -> doc.getOperation() != Document.Operation.DELETE).collect(Collectors.toList());
        List adds = documentsToAdd.stream().map(arg_0 -> oldBatch.get(arg_0)).collect(Collectors.toList());
        if (adds.size() > 0) {
            Map<String, String> params = this.getParams();
            if (params == null) {
                SendToSolrCloudProcessor.markIndexing(documentsToAdd, oldBatch.size());
                this.getSolrClient().add(adds);
            } else {
                UpdateRequest req = new UpdateRequest();
                req.add(adds);
                for (String s : params.keySet()) {
                    req.setParam(s, params.get(s));
                }
                SendToSolrCloudProcessor.markIndexing(documentsToAdd, oldBatch.size());
                this.getSolrClient().request((SolrRequest)req);
            }
        }
        if ((documentsToDelete = oldBatch.keySet().stream().filter(doc -> doc.getOperation() == Document.Operation.DELETE).collect(Collectors.toList())).size() > 0) {
            SendToSolrCloudProcessor.markIndexing(documentsToDelete, oldBatch.size());
            this.getSolrClient().deleteById(documentsToDelete.stream().map(Document::getId).collect(Collectors.toList()));
        }
        for (Document document : oldBatch.keySet()) {
            if (document.getOperation() == Document.Operation.DELETE) {
                document.setStatus(Status.INDEXED, "{} deleted from solr successfully", new Serializable[]{document.getId()});
            } else {
                document.setStatus(Status.INDEXED, "{} sent to solr successfully", new Serializable[]{document.getId()});
            }
            document.reportDocStatus();
        }
    }

    private static void markIndexing(Collection<Document> documents, int size) {
        for (Document document : documents) {
            document.setStatus(Status.INDEXING, "Indexing started for a batch of " + size + " documents", new Serializable[0]);
            document.reportDocStatus();
        }
    }

    @Override
    protected boolean exceptionIndicatesDocumentIssue(Exception e) {
        return e instanceof SolrServerException;
    }

    @Override
    protected SolrInputDocument convertDoc(Document document) {
        Delete doc = document.getOperation() == Document.Operation.DELETE ? new Delete() : new SolrInputDocument();
        for (String field : document.keySet()) {
            List<String> values = document.get(field);
            if (values.size() > 1) {
                doc.addField(field, values);
            } else {
                doc.addField(field, document.getFirstValue(field));
            }
            if (document.getRawData() != null && document.getRawData().length > 0) {
                String value = new String(document.getRawData(), StandardCharsets.UTF_8);
                doc.addField(this.textContentField, value);
            }
            if (this.fieldsField == null) continue;
            doc.addField(this.fieldsField, field);
        }
        return doc;
    }

    Map<String, String> getParams() {
        return this.params;
    }

    void setParams(Map<String, String> updateChain) {
        this.params = updateChain;
    }

    CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    void setSolrClient(CloudSolrClient solrClient) {
        this.solrClient = solrClient;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends BatchProcessor.Builder<SolrInputDocument> {
        SendToSolrCloudProcessor obj = new SendToSolrCloudProcessor();
        List<String> zkList = new ArrayList<String>();
        String chroot;

        public Builder placingTextContentIn(String field) {
            this.getObj().textContentField = field;
            return this;
        }

        public Builder usingCollection(String collection) {
            this.getObj().collection = collection;
            return this;
        }

        public Builder withRequestParameters(Map<String, String> params) {
            this.getObj().params = params;
            return this;
        }

        public Builder withZookeeper(String zk) {
            if (((String)zk).indexOf(":") < -1) {
                zk = (String)zk + ":2181";
            }
            this.zkList.add((String)zk);
            return this;
        }

        public Builder zkChroot(String chroot) {
            this.chroot = chroot;
            return this;
        }

        public Builder withDocFieldsIn(String fieldsField) {
            this.getObj().fieldsField = fieldsField;
            return this;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected SendToSolrCloudProcessor getObj() {
            return this.obj;
        }

        private void setObj(SendToSolrCloudProcessor obj) {
            this.obj = obj;
        }

        @Override
        public SendToSolrCloudProcessor build() {
            SendToSolrCloudProcessor tmp = this.getObj();
            this.setObj(new SendToSolrCloudProcessor());
            tmp.setSolrClient((CloudSolrClient)new CloudSolrClient.Builder(this.zkList, Optional.ofNullable(this.chroot)).build());
            tmp.getSolrClient().setDefaultCollection(tmp.collection);
            return tmp;
        }
    }

    private static class Delete
    extends SolrInputDocument {
        private Delete() {
        }
    }
}

