/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import com.copyright.easiertest.SimpleProperty;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class SetReadableFileSize
implements DocumentProcessor {
    private String inputField;
    private String numericAndUnitsField;
    private String unitsField;
    private String numericField;
    private String name;

    @Override
    public Document[] processDocument(Document document) {
        String val = document.getFirstValue(this.getInputField());
        if (StringUtils.isNotBlank((CharSequence)val)) {
            long lFileSize = Long.parseLong(val);
            String readableFileSize = FileUtils.byteCountToDisplaySize((long)lFileSize);
            if (StringUtils.isNotBlank((CharSequence)this.getNumericAndUnitsField())) {
                document.put(this.getNumericAndUnitsField(), readableFileSize);
            }
            String[] parts = readableFileSize.split(" ");
            if (StringUtils.isNotBlank((CharSequence)this.getUnitsField())) {
                document.put(this.getUnitsField(), parts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)this.getNumericField())) {
                document.put(this.getNumericField(), parts[0]);
            }
        }
        return new Document[]{document};
    }

    @SimpleProperty
    public String getInputField() {
        return this.inputField;
    }

    @SimpleProperty
    public String getNumericAndUnitsField() {
        return this.numericAndUnitsField;
    }

    @SimpleProperty
    public String getUnitsField() {
        return this.unitsField;
    }

    @SimpleProperty
    public String getNumericField() {
        return this.numericField;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<SetReadableFileSize> {
        SetReadableFileSize obj = new SetReadableFileSize();

        public Builder from(String fromField) {
            this.getObj().inputField = fromField;
            return this;
        }

        public Builder intoNumericAndUnitsField(String toField) {
            this.getObj().numericAndUnitsField = toField;
            return this;
        }

        public Builder intoUnitsField(String toField) {
            this.getObj().unitsField = toField;
            return this;
        }

        public Builder intoNumericField(String toField) {
            this.getObj().numericField = toField;
            return this;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected SetReadableFileSize getObj() {
            return this.obj;
        }

        private void setObj(SetReadableFileSize obj) {
            this.obj = obj;
        }

        @Override
        public SetReadableFileSize build() {
            SetReadableFileSize object = this.getObj();
            this.setObj(new SetReadableFileSize());
            return object;
        }
    }
}

