/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class SetStaticValue
implements DocumentProcessor {
    private String name;
    private String valueToInsert;
    private String fieldToInsert;
    private boolean editExisting = true;
    private boolean addValueToExisting = true;

    @Override
    public Document[] processDocument(Document document) {
        if (!this.isEditExisting() && !document.get(this.getFieldToInsert()).isEmpty()) {
            return new Document[]{document};
        }
        if (!this.isAddValueToExisting()) {
            document.removeAll(this.getFieldToInsert());
        }
        document.put(this.getFieldToInsert(), this.getValueToInsert());
        return new Document[]{document};
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFieldToInsert() {
        return this.fieldToInsert;
    }

    public boolean isEditExisting() {
        return this.editExisting;
    }

    public boolean isAddValueToExisting() {
        return this.addValueToExisting;
    }

    public String getValueToInsert() {
        return this.valueToInsert;
    }

    public static class Builder
    extends NamedBuilder<SetStaticValue> {
        SetStaticValue obj = new SetStaticValue();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected SetStaticValue getObj() {
            return this.obj;
        }

        public Builder adding(String fieldName) {
            this.getObj().fieldToInsert = fieldName;
            return this;
        }

        public Builder withValue(String value) {
            this.getObj().valueToInsert = value;
            return this;
        }

        public Builder skipIfHasValue() {
            this.getObj().editExisting = false;
            return this;
        }

        public Builder replaceExistingValue() {
            this.getObj().addValueToExisting = false;
            return this;
        }

        private void setObj(SetStaticValue obj) {
            this.obj = obj;
        }

        @Override
        public SetStaticValue build() {
            SetStaticValue object = this.getObj();
            this.setObj(new SetStaticValue());
            return object;
        }
    }
}

