/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class SimpleDateTimeReformatter
implements DocumentProcessor {
    private static final Logger log = LogManager.getLogger();
    private String inputField;
    private String outputField;
    private boolean overwrite = true;
    private DateTimeFormatter inputFormat;
    private DateTimeFormatter outputFormat = DateTimeFormatter.ISO_INSTANT;
    private String name;

    @Override
    public Document[] processDocument(Document document) {
        List<String> input = document.get(this.inputField);
        if (this.inputField.equals(this.outputField)) {
            document.removeAll(this.inputField);
        }
        boolean updated = false;
        for (String s : input) {
            Instant instant = null;
            if (this.inputFormat != null) {
                instant = this.inputFormat.parse((CharSequence)s, Instant::from);
                log.warn("could not parse date field {} with value {} as a {}", (Object)this.inputField, (Object)s, (Object)this.inputFormat.toString());
            }
            if (instant == null) {
                try {
                    instant = Instant.ofEpochMilli(Long.parseLong(s));
                }
                catch (NumberFormatException nfe) {
                    log.warn("could not parse date field {} with value {} as a Long", (Object)this.inputField, (Object)s);
                }
            }
            if (instant == null) continue;
            if (this.overwrite) {
                document.removeAll(this.outputField);
            }
            document.put(this.outputField, this.outputFormat.format(instant));
            updated = true;
        }
        if (!updated && this.inputField.equals(this.outputField)) {
            document.putAll(this.inputField, input);
            if (!input.isEmpty()) {
                log.warn("reformatting of {} using {} failed. Old value ({}) preserved.", (Object)this.inputField, (Object)this.inputFormat, input);
            }
        }
        return new Document[]{document};
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<SimpleDateTimeReformatter> {
        SimpleDateTimeReformatter obj = new SimpleDateTimeReformatter();

        public Builder from(String fromField) {
            this.getObj().inputField = fromField;
            return this;
        }

        public Builder into(String toField) {
            this.getObj().outputField = toField;
            return this;
        }

        public Builder replaceDestination(boolean overwrite) {
            this.getObj().overwrite = overwrite;
            return this;
        }

        public Builder readingFormat(String inputFormat) {
            this.getObj().inputFormat = DateTimeFormatter.ofPattern(inputFormat);
            return this;
        }

        public Builder writingFormat(String outputFormat) {
            this.getObj().outputFormat = DateTimeFormatter.ofPattern(outputFormat);
            return this;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected SimpleDateTimeReformatter getObj() {
            return this.obj;
        }

        private void setObj(SimpleDateTimeReformatter obj) {
            this.obj = obj;
        }

        @Override
        public SimpleDateTimeReformatter build() {
            SimpleDateTimeReformatter object = this.getObj();
            this.setObj(new SimpleDateTimeReformatter());
            return object;
        }
    }
}

