/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class SplitFieldProcessor
implements DocumentProcessor {
    private String name;
    private String delimiter;
    private String field;
    private boolean trim;
    private static final Logger log = LogManager.getLogger();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document[] processDocument(Document document) {
        List<String> oldValues = document.get(this.field);
        log.trace("old values: {} ({})", oldValues, (Object)oldValues.size());
        ArrayList<String> newValues = new ArrayList<String>(oldValues.size() * 10);
        for (String v : oldValues) {
            String[] parts = v.split(this.delimiter);
            log.trace("split on delimiter '{}' gave {} parts", (Object)this.delimiter, (Object)parts.length);
            for (String part : parts) {
                if (this.trim) {
                    newValues.add(part.trim());
                    continue;
                }
                newValues.add(part);
            }
        }
        document.replaceValues(this.field, newValues);
        log.trace("new values: {} ({})", newValues, (Object)newValues.size());
        return new Document[]{document};
    }

    public static class Builder
    extends NamedBuilder<SplitFieldProcessor> {
        SplitFieldProcessor obj = new SplitFieldProcessor();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder trimingWhiteSpace(boolean trim) {
            this.getObj().trim = trim;
            return this;
        }

        @Override
        protected SplitFieldProcessor getObj() {
            return this.obj;
        }

        public Builder splittingField(String field) {
            this.getObj().field = field;
            return this;
        }

        public Builder onDelimiter(String delimiter) {
            this.getObj().delimiter = delimiter;
            return this;
        }

        private void setObj(SplitFieldProcessor obj) {
            this.obj = obj;
        }

        @Override
        public SplitFieldProcessor build() {
            SplitFieldProcessor object = this.getObj();
            this.setObj(new SplitFieldProcessor());
            return object;
        }
    }
}

