/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;
import org.jesterj.ingest.trie.PatriciaTrie;

public class StaxExtractingProcessor
implements DocumentProcessor {
    static final Logger log = LogManager.getLogger();
    private String name;
    private int capacity;
    private final PatriciaTrie<List<ElementSpec>> extractMapping = new PatriciaTrie();
    private boolean failOnLongPath = false;
    private XMLResolver resolver;
    private boolean supportExternalEntities;

    @Override
    public Document[] processDocument(Document document) {
        ArrayList<LimitedStaxHandler> handlers = new ArrayList<LimitedStaxHandler>();
        CharBuffer path = CharBuffer.allocate(this.capacity);
        path.flip();
        if (log.isTraceEnabled()) {
            log.trace(new String(document.getRawData()));
        }
        String trim = new String(document.getRawData()).trim();
        byte[] buf = trim.getBytes();
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(buf);
        XMLInputFactory2 xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newFactory("javax.xml.stream.XMLInputFactory", Thread.currentThread().getContextClassLoader());
        if (this.supportExternalEntities) {
            if (!xmlInputFactory.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
                throw new RuntimeException(xmlInputFactory + " doesn't support javax.xml.stream.isSupportingExternalEntities");
            }
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)true);
        }
        xmlInputFactory.setXMLResolver(this.resolver);
        try {
            XMLStreamReader2 xmlStreamReader = (XMLStreamReader2)xmlInputFactory.createXMLStreamReader((InputStream)xmlInputStream);
            block7: while (xmlStreamReader.hasNext()) {
                int eventType = xmlStreamReader.next();
                switch (eventType) {
                    case 1: {
                        String s = xmlStreamReader.getName().toString();
                        if (!this.addToPath(s, path) && this.failOnLongPath) {
                            throw new RuntimeException("Exceeded allowable xml nesting depth. Configure larger buffer with Builder.withPathBuffer(int), or turn off errors for long paths with Builder.failOnLongPath(false)");
                        }
                        log.trace("Starting {}", (Object)path.toString());
                        List specList = (List)this.extractMapping.get(path);
                        if (specList != null) {
                            for (ElementSpec spec : specList) {
                                LimitedStaxHandler handler2 = spec.handleIfMatches(xmlStreamReader, spec);
                                if (handler2 == null) continue;
                                Supplier[] supplierArray = new Supplier[3];
                                supplierArray[0] = document::getId;
                                supplierArray[1] = () -> handler2.getSpec().getDestField();
                                supplierArray[2] = path::toString;
                                log.trace("{} adding handler {} for {}", supplierArray);
                                handlers.add(handler2);
                            }
                        }
                        for (LimitedStaxHandler handler3 : handlers) {
                            Supplier[] supplierArray = new Supplier[3];
                            supplierArray[0] = document::getId;
                            supplierArray[1] = () -> path;
                            supplierArray[2] = () -> handler3.getSpec().getDestField();
                            log.trace("{} start element called for {} ({})", supplierArray);
                            handler3.onStartElement(xmlStreamReader);
                        }
                        continue block7;
                    }
                    case 2: {
                        log.trace("Ending path {}", (Object)path.toString());
                        List specEndingList = (List)this.extractMapping.get(path);
                        if (specEndingList != null) {
                            for (LimitedStaxHandler handler2 : handlers) {
                                for (ElementSpec elementSpec : specEndingList) {
                                    if (handler2.getSpec() != elementSpec) continue;
                                    Supplier[] supplierArray = new Supplier[3];
                                    supplierArray[0] = document::getId;
                                    supplierArray[1] = path::toString;
                                    supplierArray[2] = () -> handler2.getSpec().getDestField();
                                    log.trace("{} calling onEndElement for {} ({})", supplierArray);
                                    handler2.onEndElement(xmlStreamReader);
                                    Supplier[] supplierArray2 = new Supplier[3];
                                    supplierArray2[0] = document::getId;
                                    supplierArray2[1] = elementSpec::getDestField;
                                    supplierArray2[2] = () -> path;
                                    log.trace("{} putting field {} for path {}", supplierArray2);
                                    document.put(elementSpec.getDestField(), handler2.toString());
                                    handler2.reset();
                                }
                            }
                            handlers.removeIf(handler -> specEndingList.contains(handler.getSpec()));
                        }
                        for (LimitedStaxHandler handler2 : handlers) {
                            Supplier[] supplierArray = new Supplier[3];
                            supplierArray[0] = document::getId;
                            supplierArray[1] = path::toString;
                            supplierArray[2] = () -> handler2.getSpec().getDestField();
                            log.trace("{} calling onEndElement for {} ({})", supplierArray);
                            handler2.onEndElement(xmlStreamReader);
                        }
                        this.decrementPath(path);
                        break;
                    }
                    case 4: {
                        for (LimitedStaxHandler handler2 : handlers) {
                            Supplier[] supplierArray = new Supplier[3];
                            supplierArray[0] = document::getId;
                            supplierArray[1] = path::toString;
                            supplierArray[2] = () -> handler2.getSpec().getDestField();
                            log.trace("{} calling onCharacters for {} ({})", supplierArray);
                            handler2.onCharacters(xmlStreamReader);
                        }
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("Exception Processing XML in StaxExtractingProcessor:", e);
            log.trace("Offending XML:\n{}", (Object)trim);
            log.error((Object)e);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return new Document[]{document};
    }

    private void decrementPath(CharBuffer path) {
        int lastSlash = 0;
        path.rewind();
        for (int i = 0; i < path.limit(); ++i) {
            if (path.charAt(i) != '/') continue;
            lastSlash = i;
        }
        path.limit(lastSlash);
    }

    private boolean addToPath(String s, CharBuffer path) {
        s = s.replaceAll("/", "%2F");
        int i = 0;
        boolean result = false;
        while (path.limit() < path.capacity()) {
            if (s.length() <= i) {
                result = true;
                break;
            }
            if (i == 0) {
                path.position(path.limit());
                path.limit(path.limit() + 1);
                path.append('/');
            }
            path.position(path.limit());
            path.limit(path.limit() + 1);
            path.append(s.charAt(i++));
        }
        path.rewind();
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class LimitedStaxHandler {
        protected final StringBuilder accumulator;
        private final ElementSpec spec;

        protected LimitedStaxHandler(StringBuilder accumulator, ElementSpec spec) {
            this.accumulator = accumulator;
            this.spec = spec;
        }

        protected void onCharacters(XMLStreamReader2 xmlStreamReader) {
            this.accumulator.append(xmlStreamReader.getText());
        }

        protected void onStartElement(XMLStreamReader2 xmlStreamReader) {
        }

        protected void onEndElement(XMLStreamReader2 xmlStreamReader) {
        }

        public String toString() {
            return this.accumulator.toString();
        }

        public ElementSpec getSpec() {
            return this.spec;
        }

        public void reset() {
            this.accumulator.delete(0, this.accumulator.length());
        }
    }

    public static class DefaultHandlerFactory
    implements LimitedStaxHandlerFactory {
        @Override
        public LimitedStaxHandler newInstance(StringBuilder accumulator, ElementSpec spec) {
            return new LimitedStaxHandler(accumulator, spec);
        }
    }

    public static interface LimitedStaxHandlerFactory {
        public LimitedStaxHandler newInstance(StringBuilder var1, ElementSpec var2);
    }

    public static class ElementSpec {
        private final String destField;
        private final Set<Attribute> attrsToInclude = new LinkedHashSet<Attribute>();
        private final Map<Attribute, Pattern> attrValueMatchers = new LinkedHashMap<Attribute, Pattern>();
        private final LimitedStaxHandlerFactory fact;

        public ElementSpec(String destField, LimitedStaxHandlerFactory factory) {
            this.destField = destField;
            this.fact = factory;
        }

        public ElementSpec(String destField) {
            this(destField, new DefaultHandlerFactory());
        }

        public ElementSpec inclAttributeText(String namespaceUri, String attrName) {
            this.attrsToInclude.add(new Attribute(namespaceUri, attrName));
            return this;
        }

        public ElementSpec matchOnAttrValue(String namespaceUri, String attrName, Pattern pattern) {
            this.attrValueMatchers.put(new Attribute(namespaceUri, attrName), pattern);
            return this;
        }

        public LimitedStaxHandler handleIfMatches(XMLStreamReader2 reader, ElementSpec spec) {
            if (this.matches(reader)) {
                StringBuilder perMatchAccumulator = new StringBuilder();
                for (Attribute attr : this.attrsToInclude) {
                    perMatchAccumulator.append(reader.getAttributeValue(attr.getNamespace(), attr.getQname()));
                    perMatchAccumulator.append(" ");
                }
                return this.fact.newInstance(perMatchAccumulator, spec);
            }
            return null;
        }

        protected boolean matches(XMLStreamReader2 reader) {
            for (Map.Entry<Attribute, Pattern> attributePatt : this.attrValueMatchers.entrySet()) {
                Attribute attr = attributePatt.getKey();
                if (reader.getAttributeIndex(attr.getNamespace(), attr.getQname()) < 0) {
                    return false;
                }
                String attributeValue = reader.getAttributeValue(attr.getNamespace(), attr.getQname());
                if (attributePatt.getValue().matcher(attributeValue).matches()) continue;
                return false;
            }
            return true;
        }

        public String getDestField() {
            return this.destField;
        }
    }

    public static class Attribute {
        private final String namespace;
        private final String qname;

        public String getNamespace() {
            return this.namespace;
        }

        public String getQname() {
            return this.qname;
        }

        public Attribute(String key, String qname) {
            this.namespace = key;
            this.qname = qname;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return Objects.equals(this.namespace, attribute.namespace) && Objects.equals(this.qname, attribute.qname);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.qname);
        }
    }

    public static class Builder
    extends NamedBuilder<StaxExtractingProcessor> {
        StaxExtractingProcessor obj = new StaxExtractingProcessor();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder withPathBuffer(int size) {
            this.getObj().capacity = size;
            return this;
        }

        public Builder failOnLongPath(boolean fail) {
            this.getObj().failOnLongPath = fail;
            return this;
        }

        public Builder extracting(String path, ElementSpec field) {
            this.getObj().extractMapping.computeIfAbsent(path, f -> new ArrayList()).add(field);
            return this;
        }

        public Builder withResolver(XMLResolver resolver) {
            this.getObj().resolver = resolver;
            return this;
        }

        public Builder isSupportingExternalEntities(boolean support) {
            this.getObj().supportExternalEntities = support;
            return this;
        }

        @Override
        protected StaxExtractingProcessor getObj() {
            return this.obj;
        }

        private void setObj(StaxExtractingProcessor obj) {
            this.obj = obj;
        }

        @Override
        public StaxExtractingProcessor build() {
            StaxExtractingProcessor object = this.getObj();
            this.setObj(new StaxExtractingProcessor());
            return object;
        }
    }
}

