/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class TikaProcessor
implements DocumentProcessor {
    private static final Logger log = LogManager.getLogger();
    private String name;
    private String suffix;
    private int maxLength = -1;
    private TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
    private boolean replaceRaw = true;
    private String destField = null;

    @Override
    public Document[] processDocument(Document document) {
        block13: {
            try {
                byte[] rawData = document.getRawData();
                if (rawData == null) {
                    log.debug("Skipping document without data in " + this.getName());
                    return new Document[]{document};
                }
                Tika tika = new Tika(this.tikaConfig);
                tika.setMaxStringLength(document.getRawData().length);
                Metadata metadata = new Metadata();
                try (ByteArrayInputStream bais = new ByteArrayInputStream(rawData);){
                    String textContent = tika.parseToString((InputStream)bais, metadata, this.maxLength);
                    if (this.replaceRaw) {
                        document.setRawData(textContent.getBytes(StandardCharsets.UTF_8));
                    }
                    if (this.destField != null) {
                        document.put(this.destField, textContent);
                    }
                    for (String name : metadata.names()) {
                        document.put(this.sanitize(name) + this.plusSuffix(), metadata.get(name));
                    }
                }
                catch (IOException | TikaException e) {
                    log.debug("Tika processing failure!", e);
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable t) {
                boolean isAccessControl = t instanceof AccessControlException;
                boolean isSecurity = t instanceof SecurityException;
                if (isAccessControl || isSecurity) break block13;
                throw t;
            }
        }
        return new Document[]{document};
    }

    private String plusSuffix() {
        return this.suffix == null ? "" : this.suffix;
    }

    private String sanitize(String dirty) {
        StringBuilder clean = new StringBuilder(dirty.length());
        for (char c : dirty.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                clean.append(c);
                continue;
            }
            clean.append('_');
        }
        return clean.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends NamedBuilder<TikaProcessor> {
        TikaProcessor obj = new TikaProcessor();

        @Override
        protected TikaProcessor getObj() {
            return this.obj;
        }

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder appendingSuffix(String suffix) {
            this.getObj().suffix = suffix;
            return this;
        }

        public Builder truncatingTextTo(int chars) {
            this.getObj().maxLength = chars;
            return this;
        }

        public Builder replacingRawData(boolean replaceRaw) {
            this.getObj().replaceRaw = replaceRaw;
            return this;
        }

        public Builder intoField(String field) {
            this.getObj().destField = field;
            return this;
        }

        public Builder configuredWith(org.w3c.dom.Document config) throws TikaException, IOException {
            this.getObj().tikaConfig = new TikaConfig(config);
            return this;
        }

        private void setObj(TikaProcessor obj) {
            this.obj = obj;
        }

        @Override
        public TikaProcessor build() {
            TikaProcessor object = this.getObj();
            this.setObj(new TikaProcessor());
            return object;
        }
    }
}

