/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.util.stream.Collectors;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class TrimValues
implements DocumentProcessor {
    private String name;
    private String fieldToTrim;

    @Override
    public Document[] processDocument(Document document) {
        document.putAll(this.fieldToTrim, document.removeAll(this.fieldToTrim).stream().map(String::trim).collect(Collectors.toList()));
        return new Document[]{document};
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFieldToTrim() {
        return this.fieldToTrim;
    }

    public static class Builder
    extends NamedBuilder<TrimValues> {
        TrimValues obj = new TrimValues();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected TrimValues getObj() {
            return this.obj;
        }

        public Builder trimming(String fieldName) {
            this.getObj().fieldToTrim = fieldName;
            return this;
        }

        private void setObj(TrimValues obj) {
            this.obj = obj;
        }

        @Override
        public TrimValues build() {
            TrimValues object = this.getObj();
            this.setObj(new TrimValues());
            return object;
        }
    }
}

