/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class UrlEncodeFieldProcessor
implements DocumentProcessor {
    private String name;
    private String fieldToEncode;
    private String charset;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document[] processDocument(Document document) {
        List<String> values = document.get(this.fieldToEncode);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            try {
                values.set(i, URLEncoder.encode(value, this.charset));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return new Document[]{document};
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldToEncode(String fieldToEncode) {
        this.fieldToEncode = fieldToEncode;
    }

    public void setCharset(String encoding) {
        this.charset = encoding;
    }

    public static class Builder
    extends NamedBuilder<UrlEncodeFieldProcessor> {
        UrlEncodeFieldProcessor obj = new UrlEncodeFieldProcessor();

        public Builder named(String name) {
            this.getObj().setName(name);
            return this;
        }

        @Override
        protected UrlEncodeFieldProcessor getObj() {
            return this.obj;
        }

        public Builder encodingField(String fieldName) {
            this.getObj().setFieldToEncode(fieldName);
            return this;
        }

        public Builder withCharacterEncoding(String charset) {
            this.getObj().setCharset(charset);
            return this;
        }

        private void setObj(UrlEncodeFieldProcessor obj) {
            this.obj = obj;
        }

        @Override
        public UrlEncodeFieldProcessor build() {
            UrlEncodeFieldProcessor object = this.getObj();
            this.setObj(new UrlEncodeFieldProcessor());
            return object;
        }
    }
}

