/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.processors;

import com.copyright.easiertest.SimpleProperty;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.impl.NamedBuilder;

public class WrappingProcessor
implements DocumentProcessor {
    private String name;
    private DocumentProcessor wrapped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document[] processDocument(Document document) {
        Document[] documents = null;
        try {
            this.before(document);
            documents = this.getWrapped().processDocument(document);
            Document[] documentArray = this.success(documents);
            return documentArray;
        }
        catch (Exception e) {
            Document[][] results = this.wrapRef(documents);
            if (this.error(e, document, results)) {
                throw e;
            }
            if (results[0] == null) {
                throw new RuntimeException("Invalid WrappingProcessor implementation. Contract violation: results[0] is null");
            }
            Document[] result = results[0];
            for (int i = 0; i < result.length; ++i) {
                Document document1 = result[i];
                if (document1 != null) continue;
                throw new RuntimeException("invalid WrappingProcessor implementation Contract violation: results[0] contains a null document at position " + i);
            }
            Document[] documentArray = result;
            return documentArray;
        }
        finally {
            this.always(document);
        }
    }

    Document[][] wrapRef(Document[] documents) {
        return new Document[][]{documents};
    }

    @Override
    @SimpleProperty
    public String getName() {
        return this.name;
    }

    public void before(Document document) {
    }

    public Document[] success(Document[] results) {
        return results;
    }

    public boolean error(Exception e, Document original, Document[][] results) {
        return true;
    }

    public void always(Document original) {
    }

    public void setName(String name) {
        this.name = name;
    }

    @SimpleProperty
    public DocumentProcessor getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(DocumentProcessor wrapped) {
        this.wrapped = wrapped;
    }

    public static class Builder
    extends NamedBuilder<WrappingProcessor> {
        WrappingProcessor obj = new WrappingProcessor();

        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder wrapping(DocumentProcessor wrapped) {
            this.getObj().setWrapped(wrapped);
            return this;
        }

        @Override
        protected WrappingProcessor getObj() {
            return this.obj;
        }

        private void setObj(WrappingProcessor obj) {
            this.obj = obj;
        }

        @Override
        public WrappingProcessor build() {
            WrappingProcessor object = this.getObj();
            this.setObj(new WrappingProcessor());
            return object;
        }
    }
}

