/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.routers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.NextSteps;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.routers.RouterBase;

public class RoundRobinRouter
extends RouterBase {
    private static final Logger log = LogManager.getLogger();
    AtomicInteger nextTarget = new AtomicInteger(0);

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public boolean isConstantNumberOfOutputDocs() {
        return true;
    }

    @Override
    public int getNumberOfOutputCopies() {
        return 1;
    }

    @Override
    public NextSteps route(Document doc) {
        Step selected;
        int tries = 0;
        int stepsAvail = this.getStep().getNextSteps().size();
        LinkedHashMap<String, Step> eligibleNextSteps = this.getStep().getEligibleNextSteps(doc);
        do {
            selected = this.selectNextStep();
        } while (++tries <= stepsAvail && !eligibleNextSteps.containsValue(selected));
        if (tries > stepsAvail) {
            log.error("Unable to find eligible next step for {}", (Object)doc.getId());
            throw new RuntimeException("Invalid router implementation, or bug. No next step selected by " + this.getName() + " for " + doc);
        }
        this.updateExcludedDestinations(doc, selected);
        return new NextSteps(doc, selected);
    }

    private Step selectNextStep() {
        int stepIndex = this.nextTarget.getAndIncrement() % this.getStep().getNextSteps().size();
        Collection<Step> values = this.getStep().getNextSteps().values();
        Iterator<Step> iter = values.iterator();
        Step selected = iter.next();
        for (int i = stepIndex; i > 0; --i) {
            selected = iter.next();
        }
        return selected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    extends RouterBase.Builder<RoundRobinRouter> {
        private RoundRobinRouter obj = new RoundRobinRouter();

        @Override
        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        @Override
        protected RoundRobinRouter getObj() {
            return this.obj;
        }

        private void setObj(RoundRobinRouter obj) {
            this.obj = obj;
        }

        @Override
        public RoundRobinRouter build() {
            if (this.getObj().name == null) {
                throw new IllegalStateException("Name of router must nto be null");
            }
            RoundRobinRouter object = this.getObj();
            this.setObj(new RoundRobinRouter());
            return object;
        }
    }
}

