/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.routers;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.NextSteps;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.routers.RouterBase;

public class RouteByStepName
extends RouterBase {
    private static final Logger log = LogManager.getLogger();
    public static final String JESTERJ_NEXT_STEP_NAME = "__JESTERJ_NEXT_STEP_NAME__";
    private String name;
    private final Map<String, String> valueToStepNameMap = new HashMap<String, String>();
    private String keyFieldName = "__JESTERJ_NEXT_STEP_NAME__";

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isConstantNumberOfOutputDocs() {
        return true;
    }

    @Override
    public int getNumberOfOutputCopies() {
        return 1;
    }

    @Override
    public NextSteps route(Document doc) {
        Step dest;
        String firstValue = doc.getFirstValue(this.getKeyFieldName());
        String possibleReplacement = this.getValueToStepNameMap().get(firstValue);
        if (possibleReplacement != null) {
            firstValue = possibleReplacement;
        }
        if ((dest = this.getStep().getEligibleNextSteps(doc).get(firstValue)) == null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = doc::getId;
            supplierArray[1] = this::getKeyFieldName;
            log.warn("Document {} dropped! no value for {} You probably want to either set a different router or provide a value for that field in the document.", supplierArray);
            this.updateExcludedDestinations(doc, new Step[0]);
        } else {
            this.updateExcludedDestinations(doc, dest);
        }
        NextSteps nextSteps = dest == null ? null : new NextSteps(doc, dest);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = doc::getId;
        supplierArray[1] = () -> nextSteps;
        supplierArray[2] = doc::dumpStatus;
        log.trace("Document {} Routed to {}, with statuses:{}", supplierArray);
        return nextSteps;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    protected void setKeyFieldName(String keyFieldName) {
        this.keyFieldName = keyFieldName;
    }

    public Map<String, String> getValueToStepNameMap() {
        return this.valueToStepNameMap;
    }

    public static class Builder
    extends RouterBase.Builder<RouteByStepName> {
        private RouteByStepName obj = new RouteByStepName();

        @Override
        public Builder named(String name) {
            this.getObj().name = name;
            return this;
        }

        public Builder keyValuesInField(String fieldName) {
            this.getObj().setKeyFieldName(fieldName);
            return this;
        }

        public Builder mappingValueFromTo(String from, String to) {
            this.getObj().getValueToStepNameMap().put(from, to);
            return this;
        }

        @Override
        protected RouteByStepName getObj() {
            return this.obj;
        }

        private void setObj(RouteByStepName obj) {
            this.obj = obj;
        }

        @Override
        public RouteByStepName build() {
            if (this.getObj().name == null) {
                throw new IllegalStateException("Name of router must nto be null");
            }
            RouteByStepName object = this.getObj();
            this.setObj(new RouteByStepName());
            return object;
        }
    }
}

