/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.routers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.Router;
import org.jesterj.ingest.model.Status;
import org.jesterj.ingest.model.Step;
import org.jesterj.ingest.model.impl.DocumentImpl;
import org.jesterj.ingest.model.impl.NamedBuilder;
import org.jesterj.ingest.model.impl.StepImpl;

public abstract class RouterBase
implements Router {
    private static final Logger log = LogManager.getLogger();
    Step step;
    String name;

    @Override
    public Step getStep() {
        return this.step;
    }

    public void updateExcludedDestinations(Document doc, Step ... destsSelected) {
        ArrayList<String> destinationsExcluded = new ArrayList<String>(this.getStep().getOutputDestinationNames());
        HashSet<String> stillDownStream = new HashSet<String>();
        if (destsSelected != null) {
            for (Step s2 : destsSelected) {
                Set<String> downstreamOutputSteps = s2.getOutputDestinationNames();
                stillDownStream.addAll(downstreamOutputSteps);
            }
        }
        for (String ps : stillDownStream) {
            destinationsExcluded.remove(ps);
        }
        destinationsExcluded.removeIf(s -> !doc.isPlanOutput((String)s));
        destinationsExcluded.removeIf(s -> {
            DocumentProcessor processor = ((StepImpl)this.getStep()).getProcessor();
            return (processor.isIdempotent() || processor.isPotent()) && s.contains(this.getStep().getName());
        });
        if (destinationsExcluded.isEmpty()) {
            return;
        }
        ((DocumentImpl)doc).setStatusForDestinations(Status.DROPPED, destinationsExcluded, "Document routed down path not leading to {} by {}", new Serializable[]{((Object)destinationsExcluded).toString(), this.getName()});
        doc.reportDocStatus();
    }

    public static abstract class Builder<T extends RouterBase>
    extends NamedBuilder<RouterBase> {
        private T obj;

        @Override
        public Builder<T> named(String name) {
            ((RouterBase)this.getObj()).name = name;
            return this;
        }

        public Builder<T> forStep(Step step) {
            ((RouterBase)this.getObj()).step = step;
            return this;
        }

        @Override
        protected T getObj() {
            return this.obj;
        }

        @Override
        public T build() {
            this.obj = null;
            return null;
        }
    }
}

