/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.scanners;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jesterj.ingest.model.impl.DocumentImpl;

public interface FileScanner {
    default public void addAttrs(BasicFileAttributes attributes, DocumentImpl doc, boolean includeAccessed) {
        if (attributes != null) {
            FileTime modifiedTime = attributes.lastModifiedTime();
            FileTime accessTime = attributes.lastAccessTime();
            FileTime creationTime = attributes.creationTime();
            if (modifiedTime != null) {
                doc.put("modified", String.valueOf(modifiedTime.toMillis()));
            }
            if (includeAccessed && accessTime != null) {
                doc.put("accessed", String.valueOf(accessTime.toMillis()));
            }
            if (creationTime != null) {
                doc.put("created", String.valueOf(creationTime.toMillis()));
            }
            doc.put("file_size", String.valueOf(attributes.size()));
        }
    }
}

