/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.scanners;

import com.copyright.easiertest.SimpleProperty;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.ConfiguredBuildable;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.DocumentProcessor;
import org.jesterj.ingest.model.Router;
import org.jesterj.ingest.model.exception.ConfigurationException;
import org.jesterj.ingest.model.exception.PersistenceException;
import org.jesterj.ingest.model.impl.DocumentImpl;
import org.jesterj.ingest.model.impl.ScannerImpl;
import org.jesterj.ingest.model.impl.StepImpl;
import org.jesterj.ingest.routers.RouterBase;
import org.jesterj.ingest.utils.SqlUtils;
import org.jetbrains.annotations.NotNull;

public class JdbcScanner
extends ScannerImpl {
    private static final Logger log = LogManager.getLogger();
    private final Object SCAN_LOCK = new Object();
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String sqlStatement;
    private String table;
    private String pkColumn;
    private String connectionTestQuery;
    private volatile transient boolean ready;
    private int fetchSize = -1;
    private boolean autoCommit;
    private int queryTimeout = -1;
    private String contentColumn;
    private final SqlUtils sqlUtils = new SqlUtils();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private volatile Connection connection;

    @Override
    public synchronized void activate() {
        this.setReady(true);
        super.activate();
    }

    @Override
    public synchronized void deactivate() {
        block3: {
            this.setReady(false);
            super.deactivate();
            try {
                if (this.isConnected()) {
                    this.connection.close();
                }
            }
            catch (Throwable e) {
                log.error("Could not close database connection on deactivate!", e);
                if (!(e instanceof Error)) break block3;
                throw (Error)e;
            }
        }
    }

    @Override
    public ScannerImpl.ScanOp getScanOperation() {
        return new ScannerImpl.ScanOp(() -> {
            Object object = this.SCAN_LOCK;
            synchronized (object) {
                this.setReady(false);
                int count = 0;
                int reqIndexing = 0;
                try {
                    log.info("{} connecting to database {}", (Object)this.getName(), (Object)this.jdbcUrl);
                    if (!this.isConnected()) {
                        this.connection = this.sqlUtils.createJdbcConnection(this.jdbcDriver, this.jdbcUrl, this.jdbcUser, this.jdbcPassword, this.autoCommit);
                    }
                    try (Statement statement = this.createStatement(this.connection);
                         ResultSet rs = statement.executeQuery(this.sqlStatement);){
                        log.info("{} successfully queried database {}", (Object)this.getName(), (Object)this.jdbcUrl);
                        String[] columnNames = this.getColumnNames(rs);
                        int docIdColumnIdx = this.getDocIdColumnIndex(columnNames, this.getDatabasePkColumnName());
                        while (rs.next() && this.isActive()) {
                            if (count == 0) {
                                log.debug("{} beginning processing of result set", (Object)this.getName());
                            }
                            String docId = rs.getString(docIdColumnIdx);
                            Document doc = this.makeDoc(rs, columnNames, docId = this.docIdFromPkVal(docId));
                            if (this.docFound(doc)) {
                                ++reqIndexing;
                            }
                            ++count;
                        }
                    }
                    catch (SQLException | PersistenceException ex) {
                        log.error(this.getName() + " JDBC scanner error, rows processed=" + count, (Throwable)ex);
                    }
                    this.processDirty();
                }
                catch (Exception e) {
                    log.error("JDBC operation for {} failed.", (Object)this.getName());
                    log.error((Object)e);
                }
                finally {
                    log.info("{} Database rows read by {}, of which {} resulted in documents submitted for processing", (Object)count, (Object)this.getName(), (Object)reqIndexing);
                    this.setReady(true);
                }
            }
        }, this);
    }

    private void setReady(boolean b) {
        this.ready = b;
    }

    @NotNull
    private String docIdFromPkVal(String docId) {
        docId = this.jdbcUrl + "/" + this.table + "/" + (String)docId;
        return docId;
    }

    private boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.prepareStatement(this.connectionTestQuery).executeQuery();
        }
        catch (SQLException throwable) {
            return false;
        }
        return true;
    }

    protected String getDatabasePkColumnName() {
        return this.pkColumn == null ? this.getPlan().getDocIdField() : this.pkColumn;
    }

    Document makeDoc(ResultSet rs, String[] columnNames, String docId) throws SQLException {
        byte[] rawBytes = this.getContentBytes(rs);
        DocumentImpl doc = new DocumentImpl(rawBytes, docId, this.getPlan(), Document.Operation.NEW, this, "SCAN");
        for (int i = 1; i <= columnNames.length; ++i) {
            String strValue;
            Object value;
            String columnName = columnNames[i - 1];
            if (columnName.equalsIgnoreCase(this.contentColumn) || columnName.equalsIgnoreCase(doc.getIdField()) || (value = rs.getObject(i)) == null) continue;
            if (value instanceof Date) {
                strValue = JdbcScanner.convertDateToString(value);
            } else if (value instanceof Clob) {
                try {
                    strValue = IOUtils.toString((Reader)((Clob)value).getCharacterStream());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading clob for " + columnName, e);
                }
            } else {
                strValue = value.toString();
            }
            doc.put(columnName, strValue);
        }
        return doc;
    }

    private byte[] getContentBytes(ResultSet rs) throws SQLException {
        Object content;
        byte[] rawBytes = null;
        if (StringUtils.isNotBlank((CharSequence)this.contentColumn) && (content = rs.getObject(this.contentColumn)) != null) {
            if (content instanceof Clob) {
                Clob clob = (Clob)content;
                try (Reader reader = clob.getCharacterStream();){
                    rawBytes = CharStreams.toString((Readable)reader).getBytes();
                }
                catch (IOException ex) {
                    String msg = String.format("I/O error while reading value of content column '%s'.", this.contentColumn);
                    log.error(msg, (Throwable)ex);
                }
            } else if (content instanceof Blob) {
                Blob blob = (Blob)content;
                try (InputStream stream = blob.getBinaryStream();){
                    rawBytes = IOUtils.toByteArray((InputStream)stream);
                }
                catch (IOException ex) {
                    String msg = String.format("I/O error while reading value of content column '%s'.", this.contentColumn);
                    log.error(msg, (Throwable)ex);
                }
            } else {
                rawBytes = content instanceof Date ? JdbcScanner.convertDateToString(content).getBytes() : content.toString().getBytes();
            }
        }
        return rawBytes;
    }

    private static String convertDateToString(Object value) {
        Instant instant = Instant.ofEpochMilli(((Date)value).getTime());
        return DATE_FORMATTER.format(instant);
    }

    private Statement createStatement(Connection conn) throws SQLException {
        Statement statement = conn.createStatement(1003, 1007);
        if (this.fetchSize != -1) {
            statement.setFetchSize(this.fetchSize);
        }
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
        return statement;
    }

    private String[] getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        String[] names = new String[meta.getColumnCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = meta.getColumnLabel(i + 1);
        }
        return names;
    }

    private int getDocIdColumnIndex(String[] columnNames, String docIdColumnName) throws PersistenceException {
        int itemIdColNum = -1;
        if (docIdColumnName != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                if (!columnNames[i].equals(docIdColumnName)) continue;
                itemIdColNum = i + 1;
                break;
            }
            if (itemIdColNum == -1) {
                throw new PersistenceException(String.format("The document ID column could not be found in the SQL result set. docIdColumn: '%s', SQL: %s, columns: %s.", docIdColumnName, this.sqlStatement, String.join((CharSequence)", ", columnNames)));
            }
        }
        return itemIdColNum;
    }

    @Override
    public boolean isScanning() {
        return !this.ready;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Document> fetchById(String id, String origination) {
        String sql = "select * from " + this.table + " where " + this.getDatabasePkColumnName() + " = ?";
        int slash = id.lastIndexOf("/") + 1;
        int hash = id.indexOf(35);
        int endOfParentDocId = hash < 0 ? id.length() : hash;
        String pkValue = id.substring(slash, endOfParentDocId);
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql);){
            preparedStatement.setString(1, pkValue);
            ResultSet resultSet = preparedStatement.executeQuery();
            Document value = null;
            if (resultSet.next()) {
                value = this.makeDoc(resultSet, this.getColumnNames(resultSet), this.docIdFromPkVal(pkValue));
            }
            if (value != null) {
                Optional<Object> optional2 = Optional.of(value);
                return optional2;
            }
            log.warn("Did not find {}", (Object)id);
            Optional<Document> optional = Optional.empty();
            return optional;
        }
        catch (SQLException e) {
            log.error("Error in sql to fetch document:[{}] args was:{}", (Object)sql, (Object)pkValue);
            log.error("Exception was:", (Throwable)e);
            return Optional.empty();
        }
        catch (ConfigurationException | PersistenceException e) {
            log.error("JDBC operation for {} failed in fetchById", (Object)this.getName());
            log.error((Object)e);
        }
        return Optional.empty();
    }

    private Connection getConnection() throws ConfigurationException, PersistenceException {
        if (!this.isConnected()) {
            this.connection = this.sqlUtils.createJdbcConnection(this.jdbcDriver, this.jdbcUrl, this.jdbcUser, this.jdbcPassword, this.autoCommit);
        }
        return this.connection;
    }

    @SimpleProperty
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    @SimpleProperty
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @SimpleProperty
    public String getJdbcUser() {
        return this.jdbcUser;
    }

    @SimpleProperty
    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    @SimpleProperty
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @SimpleProperty
    public int getFetchSize() {
        return this.fetchSize;
    }

    @SimpleProperty
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @SimpleProperty
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @SimpleProperty
    public String getContentColumn() {
        return this.contentColumn;
    }

    public static class Builder
    extends ScannerImpl.Builder {
        private JdbcScanner obj = new JdbcScanner();

        @Override
        public Builder detectChangesViaHashing(boolean hash) {
            super.detectChangesViaHashing(hash);
            return this;
        }

        @Override
        public Builder rememberScannedIds(boolean remember) {
            super.rememberScannedIds(remember);
            return this;
        }

        @Override
        public Builder retryErroredDocsUpTo(int retries) {
            super.retryErroredDocsUpTo(retries);
            return this;
        }

        @Override
        public StepImpl.Builder withShutdownWait(int millis) {
            super.withShutdownWait(millis);
            return this;
        }

        @Override
        public StepImpl.Builder withProcessor(ConfiguredBuildable<? extends DocumentProcessor> processor) {
            super.withProcessor(processor);
            return this;
        }

        public Builder withJdbcDriver(String jdbcDriver) {
            this.getObj().jdbcDriver = jdbcDriver;
            return this;
        }

        public Builder withJdbcUrl(String jdbcUrl) {
            this.getObj().jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder withJdbcUser(String jdbcUser) {
            this.getObj().jdbcUser = jdbcUser;
            return this;
        }

        public Builder withJdbcPassword(String jdbcPassword) {
            this.getObj().jdbcPassword = jdbcPassword;
            return this;
        }

        public Builder withSqlStatement(String sqlStatement) {
            this.getObj().sqlStatement = sqlStatement;
            return this;
        }

        public Builder representingTable(String table) {
            this.getObj().table = table;
            return this;
        }

        public Builder withContentColumn(String contentColumn) {
            this.getObj().contentColumn = contentColumn;
            return this;
        }

        public Builder withPKColumn(String pkCol) {
            this.getObj().pkColumn = pkCol;
            return this;
        }

        public Builder testingConnectionWith(String query) {
            this.getObj().connectionTestQuery = query;
            return this;
        }

        public Builder withFetchSize(int fetchSize) {
            this.getObj().fetchSize = fetchSize;
            return this;
        }

        public Builder withAutoCommit(boolean autoCommit) {
            this.getObj().autoCommit = autoCommit;
            return this;
        }

        public Builder withQueryTimeout(int queryTimeout) {
            this.getObj().queryTimeout = queryTimeout;
            return this;
        }

        @Override
        public Builder batchSize(int size) {
            super.batchSize(size);
            return this;
        }

        @Override
        public Builder named(String stepName) {
            super.named(stepName);
            return this;
        }

        @Override
        public Builder routingBy(RouterBase.Builder<? extends Router> router) {
            super.routingBy((RouterBase.Builder)router);
            return this;
        }

        @Override
        public Builder scanFreqMS(long interval) {
            this.getObj().setInterval(interval);
            return this;
        }

        @Override
        public ScannerImpl build() {
            if (this.obj.jdbcDriver == null || this.obj.jdbcPassword == null || this.obj.jdbcUser == null || this.obj.jdbcUrl == null || this.obj.table == null) {
                throw new IllegalStateException("jdbc driver, password, user, url, and the table being represented must be supplied");
            }
            super.build();
            JdbcScanner tmp = this.getObj();
            this.obj = new JdbcScanner();
            return tmp;
        }

        @Override
        protected JdbcScanner getObj() {
            return this.obj;
        }
    }
}

