/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.scanners;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jesterj.ingest.model.Document;
import org.jesterj.ingest.model.Router;
import org.jesterj.ingest.model.impl.DocumentImpl;
import org.jesterj.ingest.model.impl.ScannerImpl;
import org.jesterj.ingest.routers.RouterBase;
import org.jesterj.ingest.scanners.FileScanner;

public class SimpleFileScanner
extends ScannerImpl
implements FileScanner {
    private static final Logger log = LogManager.getLogger();
    private final AtomicInteger opCountTrace = new AtomicInteger(0);
    private static final Object SCAN_LOCK = new Object();
    private File rootDir;
    private volatile transient boolean scanning;
    private final MemoryUsage heapMemoryUsage;
    private int memWaitTimeout = 30000;
    private boolean includeAccessTime = false;

    protected SimpleFileScanner() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
    }

    @Override
    public ScannerImpl.ScanOp getScanOperation() {
        return new ScannerImpl.ScanOp(() -> {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.opCountTrace::incrementAndGet;
            log.trace("Scan Op:{}", supplierArray);
            Object object = SCAN_LOCK;
            synchronized (object) {
                log.trace("Acquired lock on " + this);
                this.setScanning(true);
                try {
                    log.trace("About to walk");
                    Files.walkFileTree(this.rootDir.toPath(), new RootWalker());
                    log.trace("FileWalk complete");
                }
                catch (IOException e) {
                    log.error("failed to walk filesystem!", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    this.processDirty();
                    this.setScanning(false);
                }
            }
        }, this);
    }

    @Override
    public boolean isScanning() {
        return this.scanning;
    }

    @Override
    public Optional<Document> fetchById(String id, String origination) {
        try {
            File file = new File(new URI(id));
            return this.makeDoc(file.toPath(), Document.Operation.NEW, Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]), origination);
        }
        catch (URISyntaxException e) {
            log.error("Malformed doc id, can't fetch document: {}", (Object)id);
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("Could not read file attributes! Document skipped!", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setScanning(boolean scanning) {
        Object object = SCAN_LOCK;
        synchronized (object) {
            this.scanning = scanning;
        }
    }

    private Optional<Document> makeDoc(Path file, Document.Operation operation, BasicFileAttributes attributes, String origination) {
        byte[] rawData = new byte[]{};
        try {
            long size = attributes.size();
            this.memThrottle(size, "Timed out waiting for available memory to process file (" + size + " bytes):" + file);
            rawData = Files.readAllBytes(file);
            log.trace("Bytes Read:{}", (Object)rawData.length);
        }
        catch (IOException e) {
            log.error("Could not read bytes from file:" + file, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Document failed (not processed) due to interrupted exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            String id = file.toRealPath(new LinkOption[0]).toUri().toASCIIString();
            DocumentImpl doc = new DocumentImpl(rawData, id, this.getPlan(), operation, this, origination);
            this.addAttrs(attributes, doc, this.includeAccessTime);
            return Optional.of(doc);
        }
        catch (IOException e) {
            log.error("Could not resolve file path. Skipping:" + file, (Throwable)e);
            return Optional.empty();
        }
    }

    private void memThrottle(long size, String message) throws InterruptedException {
        long l;
        long memWaitStart = System.currentTimeMillis();
        int count = 0;
        while (size > (l = this.heapMemoryUsage.getMax() - this.heapMemoryUsage.getUsed())) {
            if (count++ % 100 == 0) {
                log.warn("waiting for memory... ({} avail {} required for next doc)", (Object)l, (Object)size);
            }
            System.gc();
            Thread.sleep(10L);
            if (System.currentTimeMillis() - memWaitStart >= (long)this.memWaitTimeout) continue;
            log.error("Unable to free up memory to load file within {} seconds", (Object)(memWaitStart / 1000L));
            log.error("Possible sources of FileScanner memory availability issue: 1) File is very large, 2) processing of prior files is slow or stalled, 3) Memory settings are too low");
            Thread.sleep(100L);
            RuntimeException runtimeException = new RuntimeException(message);
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public static class Builder
    extends ScannerImpl.Builder {
        private SimpleFileScanner obj;

        public Builder() {
            if (this.whoAmI() == this.getClass()) {
                this.obj = new SimpleFileScanner();
            }
        }

        private Class whoAmI() {
            return new Object(){}.getClass().getEnclosingMethod().getDeclaringClass();
        }

        public Builder withRoot(File root) {
            this.getObj().rootDir = root;
            return this;
        }

        @Override
        protected SimpleFileScanner getObj() {
            return this.obj;
        }

        @Override
        public Builder batchSize(int size) {
            super.batchSize(size);
            return this;
        }

        @Override
        public Builder named(String stepName) {
            super.named(stepName);
            return this;
        }

        @Override
        public Builder routingBy(RouterBase.Builder<? extends Router> router) {
            super.routingBy((RouterBase.Builder)router);
            return this;
        }

        @Override
        public Builder scanFreqMS(long interval) {
            super.scanFreqMS(interval);
            return this;
        }

        public Builder memoryAvailabilityTimeout(int ms) {
            this.getObj().memWaitTimeout = ms;
            return this;
        }

        public Builder includingFileAccessTime(boolean include) {
            this.getObj().includeAccessTime = include;
            return this;
        }

        @Override
        public ScannerImpl build() {
            SimpleFileScanner tmp = this.obj;
            super.build();
            this.obj = new SimpleFileScanner();
            return tmp;
        }
    }

    private class RootWalker
    extends SimpleFileVisitor<Path> {
        private RootWalker() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            log.trace("found file {}", (Object)file);
            Optional<Document> document = SimpleFileScanner.this.makeDoc(file, Document.Operation.NEW, attrs, "SCAN");
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = document::get;
            log.trace("Created:{}", supplierArray);
            document.ifPresent(SimpleFileScanner.this::docFound);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            log.warn("unable to scan file " + file, (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

