/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.trie.analyzer;

import org.jesterj.ingest.trie.KeyAnalyzer;

public class CharSequenceAnalyzer
extends KeyAnalyzer<CharSequence> {
    public static final int LENGTH = 16;
    private static final int MSB = 32768;

    private static int mask(int bit) {
        return 32768 >>> bit;
    }

    @Override
    public int bitsPerElement() {
        return 16;
    }

    @Override
    public int lengthInBits(CharSequence key) {
        return key != null ? key.length() * 16 : 0;
    }

    @Override
    public int bitIndex(CharSequence key, int offsetInBits, int lengthInBits, CharSequence other, int otherOffsetInBits, int otherLengthInBits) {
        boolean allNull = true;
        if (offsetInBits % 16 != 0 || otherOffsetInBits % 16 != 0 || lengthInBits % 16 != 0 || otherLengthInBits % 16 != 0) {
            throw new IllegalArgumentException("The offsets and lengths must be at Character boundaries");
        }
        int beginIndex1 = offsetInBits / 16;
        int beginIndex2 = otherOffsetInBits / 16;
        int endIndex1 = beginIndex1 + lengthInBits / 16;
        int endIndex2 = beginIndex2 + otherLengthInBits / 16;
        int length = Math.max(endIndex1, endIndex2);
        char k = '\u0000';
        char f = '\u0000';
        for (int i = 0; i < length; ++i) {
            int index1 = beginIndex1 + i;
            int index2 = beginIndex2 + i;
            k = index1 >= endIndex1 ? (char)'\u0000' : key.charAt(index1);
            if (k != (f = other == null || index2 >= endIndex2 ? (char)'\u0000' : other.charAt(index2))) {
                int x = k ^ f;
                return i * 16 + Integer.numberOfLeadingZeros(x) - 16;
            }
            if (k == '\u0000') continue;
            allNull = false;
        }
        if (allNull) {
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isBitSet(CharSequence key, int bitIndex, int lengthInBits) {
        if (key == null || bitIndex >= lengthInBits) {
            return false;
        }
        int index = bitIndex / 16;
        int bit = bitIndex % 16;
        return (key.charAt(index) & CharSequenceAnalyzer.mask(bit)) != 0;
    }

    @Override
    public boolean isPrefix(CharSequence prefix, int offsetInBits, int lengthInBits, CharSequence key) {
        if (offsetInBits % 16 != 0 || lengthInBits % 16 != 0) {
            throw new IllegalArgumentException("Cannot determine prefix outside of Character boundaries");
        }
        int start = offsetInBits / 16;
        int distance = lengthInBits / 16;
        for (int pos = start; pos < distance; ++pos) {
            if (pos < prefix.length() && pos - start < key.length() && key.charAt(pos - start) == prefix.charAt(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == o2.getClass()) {
            return super.compare(o1, o2);
        }
        for (int i = 0; i < o1.length() && i < o2.length(); ++i) {
            if (o1.charAt(i) == o2.charAt(i)) continue;
            return o1.charAt(i) - o2.charAt(i);
        }
        return o1.length() - o2.length();
    }
}

