/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.ResourceLoader;

public class ClassSubPathResourceLoader
implements ResourceLoader {
    private final ClassLoader loader;
    private final String subpath;

    public ClassSubPathResourceLoader(ClassLoader loader, String subpath) {
        this.loader = loader;
        this.subpath = subpath;
    }

    public InputStream openResource(String resource) throws IOException {
        String finalPath = this.subpath + resource;
        InputStream stream = this.loader.getResourceAsStream(finalPath);
        if (stream == null) {
            throw new IOException("Resource not found: " + resource);
        }
        return stream;
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        try {
            return Class.forName(cname, true, this.loader).asSubclass(expectedType);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class: " + cname, e);
        }
    }

    public <T> T newInstance(String cname, Class<T> expectedType) {
        Class<T> clazz = this.findClass(cname, expectedType);
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance: " + cname, e);
        }
    }
}

