/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.utils;

import com.needhamsoftware.unojar.JarClassLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class JesterJLoader
extends URLClassLoader {
    private final LoaderWrapper parentLoader;
    private final List<LoaderWrapper> extLoaders = Collections.synchronizedList(new ArrayList());
    private static final Object notNull = new Object();
    private final ThreadLocal<HashMap<String, Object>> classesLoaded = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<HashMap<String, Object>> resourcesLoaded = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<HashMap<String, Object>> classesFound = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<HashMap<String, Object>> resourcesFound = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<HashMap<String, Object>> librariesFound = ThreadLocal.withInitial(HashMap::new);

    public JesterJLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (parent == this) {
            throw new IllegalArgumentException(parent + " is it's own Parent!");
        }
        this.parentLoader = new LoaderWrapper(parent);
    }

    public void addExtLoader(ClassLoader loader) {
        if (loader == this) {
            throw new IllegalArgumentException("ClassLoader can't be an extLoader for itself!!");
        }
        this.extLoaders.add(new LoaderWrapper(loader));
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> tmp = new ArrayList<URL>();
        for (LoaderWrapper extLoader : this.extLoaders) {
            tmp.addAll(extLoader.getUrls());
        }
        return tmp.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        if (this.resourcesLoaded.get().get(name) == notNull) {
            return this.parentLoader.getResource(name);
        }
        try {
            Object object;
            this.resourcesLoaded.get().put(name, notNull);
            URL url = null;
            for (LoaderWrapper extLoader : this.extLoaders) {
                URL url1 = extLoader.getResource(name);
                if (url1 == null) continue;
                url = url1;
                break;
            }
            if (url != null) {
                object = url;
                return object;
            }
            object = super.getResource(name);
            return object;
        }
        finally {
            this.resourcesLoaded.get().remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.classesLoaded.get().get(name) == notNull) {
            return this.parentLoader.loadClass(name, resolve);
        }
        try {
            Object object;
            this.classesLoaded.get().put(name, notNull);
            Class<?> aClass = null;
            for (LoaderWrapper extLoader : this.extLoaders) {
                Class<?> aClass1 = null;
                try {
                    aClass1 = extLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (aClass1 == null) continue;
                aClass = aClass1;
                break;
            }
            if (aClass != null) {
                object = aClass;
                return object;
            }
            object = super.loadClass(name, resolve);
            return object;
        }
        finally {
            this.classesLoaded.get().remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classesFound.get().get(name) == notNull) {
            return this.parentLoader.findClass(name);
        }
        try {
            this.classesFound.get().put(name, notNull);
            for (LoaderWrapper extLoader : this.extLoaders) {
                Class<?> aClass = null;
                try {
                    aClass = extLoader.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (aClass == null) continue;
                Class<?> clazz = aClass;
                return clazz;
            }
            Class<?> clazz = super.findClass(name);
            return clazz;
        }
        finally {
            this.classesFound.get().remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        if (this.resourcesFound.get().get(name) == notNull) {
            return this.parentLoader.findResource(name);
        }
        try {
            this.resourcesFound.get().put(name, notNull);
            for (LoaderWrapper extLoader : this.extLoaders) {
                URL url = extLoader.findResource(name);
                if (url == null) continue;
                URL uRL = url;
                return uRL;
            }
            URL uRL = super.findResource(name);
            return uRL;
        }
        finally {
            this.resourcesFound.get().remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String findLibrary(String libName) {
        if (this.librariesFound.get().get(libName) == notNull) {
            return this.parentLoader.findLibrary(libName);
        }
        try {
            String string;
            this.librariesFound.get().put(libName, notNull);
            for (LoaderWrapper extLoader : this.extLoaders) {
                String result = this.invokeFindLibrary(libName, extLoader);
                if (result == null) continue;
                String string2 = result;
                return string2;
            }
            String result = this.invokeFindLibrary(libName, this.parentLoader);
            if (result != null) {
                string = result;
                return string;
            }
            string = super.findLibrary(libName);
            return string;
        }
        finally {
            this.librariesFound.get().remove(libName);
        }
    }

    private String invokeFindLibrary(String libName, ClassLoader parent) {
        try {
            Method m = parent.getClass().getDeclaredMethod("findLibrary", String.class);
            return (String)m.invoke((Object)this.parentLoader, libName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class LoaderWrapper
    extends ClassLoader {
        private final ClassLoader parent;

        protected LoaderWrapper(ClassLoader parent) {
            super(parent);
            this.parent = parent;
        }

        public List<URL> getUrls() {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.parent instanceof URLClassLoader) {
                Collections.addAll(urls, ((URLClassLoader)this.parent).getURLs());
                return urls;
            }
            if (this.parent instanceof JarClassLoader) {
                String jarPath = ((JarClassLoader)this.parent).getOneJarPath();
                try {
                    String jarUrlStr = "jar:" + jarPath;
                    urls.add(new URL(jarUrlStr + "!/lib"));
                    urls.add(new URL(jarUrlStr + "!/main"));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("bad URL for UnoJar!", e);
                }
                return urls;
            }
            return urls;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return (Class)this.callParentMethod("findClass", new Class[]{String.class}, name);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return (Class)this.callParentMethod("loadClass", new Class[]{String.class, Boolean.TYPE}, name, resolve);
        }

        @Override
        protected URL findResource(String name) {
            try {
                return (URL)this.callParentMethod("findResource", new Class[]{String.class}, name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("JesterJLoader Could not locate resource: " + e.getMessage());
            }
        }

        @Override
        public String findLibrary(String libName) {
            try {
                return (String)this.callParentMethod("findLibrary", new Class[]{String.class}, libName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        private Object callParentMethod(String methodName, Class[] types, Object ... args) throws ClassNotFoundException {
            NoSuchMethodException originalException = null;
            Class<?> clazz = this.parent.getClass();
            do {
                try {
                    Method m = clazz.getDeclaredMethod(methodName, types);
                    m.setAccessible(true);
                    return m.invoke((Object)this.parent, args);
                }
                catch (NoSuchMethodException e) {
                    if (originalException != null) continue;
                    originalException = e;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)cause;
                    }
                    throw new RuntimeException(e);
                }
            } while ((clazz = clazz.getSuperclass()) != null);
            throw new RuntimeException(originalException);
        }
    }
}

